<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// No direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class CalcBuilderControllerexcel extends CalcBuilderController {
	/**
	 * constructor (registers additional tasks to methods)
	 * 
	 * @return void
	 */
	function __construct() {
		parent::__construct ();
		JSession::checkToken ( 'request' ) or die ( 'Invalid Token' );
		// Register Extra tasks
		$this->registerTask ( 'apply', 'store' );
		$this->registerTask ( 'save', 'store' );
	}	
	
	/**
	 * display the edit form
	 * 
	 * @return void
	 */
	function show() {
		MSHelper::__requestSetVarWrapper ( 'view', 'excel' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'default' );
		parent::display ();
	}
	
	/**
	 * save a record (and redirect to main page)
	 * 
	 * @return void
	 */
	function store() {
		$model = $this->getModel ( 'excel' );
		$returnid = $model->store ();
		if ($returnid) {
			$msg = JText::_ ( 'EXCEL_SAVE' );
		} else {
			$msg = JText::_ ( 'EXCEL_ERROR_SAVE' );
		}
		$idobj = MSHelper::__requestGetVarWrapper ( 'idobj', '' );
		$task = MSHelper::__requestGetVarWrapper ( 'task' );
		switch ($task) {
			case 'apply' :
				$link = 'index.php?option=com_calcbuilder&controller=excel&' . JSession::getFormToken () . '=1&idobj=' . $idobj .'&cid[]=' . $returnid;
				break;
			default :
				$link = 'index.php?option=com_calcbuilder&controller=utility&task=edit&' . JSession::getFormToken () . '=1&cid[]=' . $idobj ;
				break;
		}
		$this->setRedirect ( $link, $msg );
	}	
	
	/**
	 * cancel editing a record
	 * 
	 * @return void
	 */
	function cancel() {
		$msg = JText::_ ( 'OPERATION_CANCELLED' );
		$idobj = MSHelper::__requestGetVarWrapper ( 'idobj', '' );
		$link = 'index.php?option=com_calcbuilder&controller=utility&task=edit&' . JSession::getFormToken () . '=1&cid[]=' . $idobj ;
		$this->setRedirect ( $link, $msg );
	}
}

?>
