<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// No direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class CalcBuilderControllerMatrix extends CalcBuilderController {
	/**
	 * constructor (registers additional tasks to methods)
	 * 
	 * @return void
	 */
	function __construct() {
		parent::__construct ();
		JSession::checkToken ( 'request' ) or die ( 'Invalid Token' );
		// Register Extra tasks
		$this->registerTask ( 'add', 'edit' );
		$this->registerTask ( 'apply', 'save' );
	}
	function volver() {
		$idobj = MSHelper::__requestGetVarWrapper ( 'idobj', '' );
		$class = MSHelper::__requestGetVarWrapper ( 'class', '' );
		switch ($class) {
			case 0 :
				$link = 'index.php?option=com_calcbuilder&controller=product&' . JSession::getFormToken () . '=1&task=edit&cid[]=' . $idobj;
				break;
			case 1 :
				$link = 'index.php?option=com_calcbuilder&controller=utility&' . JSession::getFormToken () . '=1&task=edit&cid[]=' . $idobj;
				break;
		}
		$this->setRedirect ( $link );
	}
	
	/**
	 * display the edit form
	 * 
	 * @return void
	 */
	function edit() {
		MSHelper::__requestSetVarWrapper ( 'view', 'matrix' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'edit' );
		MSHelper::__requestSetVarWrapper ( 'hidemainmenu', 1 );
		parent::display ();
	}
	
	/**
	 * display the edit form
	 * 
	 * @return void
	 */
	function show() {
		MSHelper::__requestSetVarWrapper ( 'view', 'matrix' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'default' );
		MSHelper::__requestSetVarWrapper ( 'hidemainmenu', 1 );
		parent::display ();
	}
	
	/**
	 * save a record (and redirect to main page)
	 * 
	 * @return void
	 */
	function save() {
		$model = $this->getModel ( 'matrix' );
		$returnid = $model->store ();
		if ($returnid) {
			$msg = JText::_ ( 'MATRIX_SAVE' );
		} else {
			$msg = JText::_ ( 'MATRIX_ERROR_SAVE' );
		}
		$idobj = MSHelper::__requestGetVarWrapper ( 'idobj', '' );
		$class = MSHelper::__requestGetVarWrapper ( 'class', '' );
		$task = MSHelper::__requestGetVarWrapper ( 'task' );
		switch ($task) {
			case 'apply' :
				$link = 'index.php?option=com_calcbuilder&controller=matrix&' . JSession::getFormToken () . '=1&task=edit&idobj=' . $idobj . '&class=' . $class . '&cid[]=' . $returnid;
				break;
			default :
				$link = 'index.php?option=com_calcbuilder&controller=matrix&' . JSession::getFormToken () . '=1&idobj=' . $idobj . '&class=' . $class;
				break;
		}
		// $link = 'index.php?option=com_previda&controller=matrix&idobj='.$idobj.'&class='.$class;
		$this->setRedirect ( $link, $msg );
	}
	
	/**
	 * remove record(s)
	 * 
	 * @return void
	 */
	function remove() {
		$model = $this->getModel ( 'matrix' );
		if (! $model->delete ()) {
			$msg = JText::_ ( 'MATRIX_ERROR_DELETE' );
		} else {
			$msg = JText::_ ( 'MATRIX_DELETED' );
		}
		$idobj = MSHelper::__requestGetVarWrapper ( 'idobj', '' );
		$class = MSHelper::__requestGetVarWrapper ( 'class', '' );
		$link = 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=matrix&idobj=' . $idobj . '&class=' . $class;
		$this->setRedirect ( $link, $msg );
	}
	
	/**
	 * cancel editing a record
	 * 
	 * @return void
	 */
	function cancel() {
		$msg = JText::_ ( 'OPERATION_CANCELLED' );
		$idobj = MSHelper::__requestGetVarWrapper ( 'idobj', '' );
		$class = MSHelper::__requestGetVarWrapper ( 'class', '' );
		$link = 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=matrix&idobj=' . $idobj . '&class=' . $class;
		$this->setRedirect ( $link, $msg );
	}
}

?>
