<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// No direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class CalcbuilderControllerStats extends CalcbuilderController {
	/**
	 * constructor (registers additional tasks to methods)
	 * 
	 * @return void
	 */
	function __construct() {
		parent::__construct ();
		JSession::checkToken ( 'request' ) or die ( 'Invalid Token' );
	}
	
	/**
	 * display the edit form
	 * 
	 * @return void
	 */
	function show() {
		MSHelper::__requestSetVarWrapper ( 'view', 'stats' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'default' );
		parent::display ();
	}
	function reset() {
		$model = $this->getModel ( 'stats' );
		$return = $model->reset ();
		if ($return) {
			$msg = JText::_ ( 'STATS_DELETED' );
		} else {
			$msg = JText::_ ( 'STATS_ERROR_DELETE' );
		}
		$this->setRedirect ( 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=stats', $msg );
	}
	function volver() {
		$this->setRedirect ( 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=utility', '' );
	}
	function export() {
		MSHelper::__requestSetVarWrapper ( 'view', 'stats' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'export' );
		parent::display ();
	}
}

?>
