<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// No direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class CalcbuilderControllerUtility extends CalcbuilderController {
	/**
	 * constructor (registers additional tasks to methods)
	 * 
	 * @return void
	 */
	function __construct() {
		parent::__construct ();
		JSession::checkToken ( 'request' ) or die ( 'Invalid Token' );
		// Register Extra tasks
		$this->registerTask ( 'add', 'edit' );
		$this->registerTask ( 'apply', 'save' );
		$this->registerTask ( 'applylayout', 'savelayout' );
		$this->registerTask ( 'applyexitlayout', 'saveexitlayout' );
	}
	function matrix() {
		$idutility = MSHelper::__requestGetVarWrapper ( 'idutility', 0 );
		$link = 'index.php?option=com_calcbuilder&controller=matrix&class=1&' . JSession::getFormToken () . '=1&idobj=' . $idutility;
		$this->setRedirect ( $link );
	}
	function stats() {
		$link = 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=stats';
		$this->setRedirect ( $link, '' );
	}
	
	/**
	 * display the edit form
	 * 
	 * @return void
	 */
	function edit() {
		MSHelper::__requestSetVarWrapper ( 'view', 'utility' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'edit' );
		MSHelper::__requestSetVarWrapper ( 'hidemainmenu', 1 );
		parent::display ();
	}
	function export() {
		MSHelper::__requestSetVarWrapper ( 'view', 'utility' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'export' );
		parent::display ();
	}
	function import() {
		MSHelper::__requestSetVarWrapper ( 'view', 'utility' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'import' );
		MSHelper::__requestSetVarWrapper ( 'hidemainmenu', 1 );
		parent::display ();
	}
	function layout() {
		MSHelper::__requestSetVarWrapper ( 'view', 'utility' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'layout' );
		parent::display ();
	}
	function exitlayout() {
		MSHelper::__requestSetVarWrapper ( 'view', 'utility' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'exitlayout' );
		parent::display ();
	}
	function importsave() {
		$model = $this->getModel ( 'utility' );
		$returnid = $model->importsave ();
		if ($returnid) {
			$msg = JText::_ ( 'UTILITY_SAVED' );
		} else {
			$msg = JText::_ ( 'UTILITY_ERROR_SAVE' );
		}
		$task = MSHelper::__requestGetVarWrapper ( 'task' );
		$link = 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=utility';
		$this->setRedirect ( $link, $msg );
	}
	function volver() {
		$link = 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=utility';
		$this->setRedirect ( $link, '' );
	}
	
	/**
	 * display the edit form
	 * 
	 * @return void
	 */
	function show() {
		MSHelper::__requestSetVarWrapper ( 'view', 'utility' );
		MSHelper::__requestSetVarWrapper ( 'layout', 'default' );
		parent::display ();
	}
	
	/**
	 * save a record (and redirect to main page)
	 * 
	 * @return void
	 */
	function save() {
		$model = $this->getModel ( 'utility' );
		$returnid = $model->store ();
		if ($returnid) {
			$msg = JText::_ ( 'UTILITY_SAVED' );
		} else {
			$msg = JText::_ ( 'UTILITY_ERROR_SAVE' );
		}
		
		$task = MSHelper::__requestGetVarWrapper ( 'task' );
		switch ($task) {
			case 'apply' :
				$link = 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=utility&task=edit&cid[]=' . $returnid;
				break;
			default :
				$link = 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=utility';
				break;
		}
		
		// Check the table in so it can be edited.... we are done with it anyway
		$this->setRedirect ( $link, $msg );
	}
	
	/**
	 * remove record(s)
	 * 
	 * @return void
	 */
	function remove() {
		$model = $this->getModel ( 'utility' );
		if (! $model->delete ()) {
			$msg = JText::_ ( 'UTILITY_ERROR_DELETE' );
		} else {
			$msg = JText::_ ( 'UTILITY_DELETED' );
		}
		
		$this->setRedirect ( 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=utility', $msg );
	}
	function savelayout() {
		$model = $this->getModel ( 'utility' );
		$returnid = $model->storelayout ();
		if ($returnid) {
			$msg = JText::_ ( 'UTILITY_SAVED' );
		} else {
			$msg = JText::_ ( 'UTILITY_ERROR_SAVE' );
		}
		$task = MSHelper::__requestGetVarWrapper ( 'task' );
		switch ($task) {
			case 'applylayout' :
				$link = 'index.php?option=com_calcbuilder&controller=utility&' . JSession::getFormToken () . '=1&task=layout&cid[]=' . $returnid;
				break;
			default :
				$link = 'index.php?option=com_calcbuilder&controller=utility&' . JSession::getFormToken () . '=1&task=edit&cid[]=' . $returnid;
				break;
		}
		$this->setRedirect ( $link, $msg );
	}
	function saveexitlayout() {
		$model = $this->getModel ( 'utility' );
		$returnid = $model->storeexitlayout ();
		if ($returnid) {
			$msg = JText::_ ( 'UTILITY_SAVED' );
		} else {
			$msg = JText::_ ( 'UTILITY_ERROR_SAVE' );
		}
		$task = MSHelper::__requestGetVarWrapper ( 'task' );
		switch ($task) {
			case 'applyexitlayout' :
				$link = 'index.php?option=com_calcbuilder&controller=utility&' . JSession::getFormToken () . '=1&task=exitlayout&cid[]=' . $returnid;
				break;
			default :
				$link = 'index.php?option=com_calcbuilder&controller=utility&' . JSession::getFormToken () . '=1&task=edit&cid[]=' . $returnid;
				break;
		}
		$this->setRedirect ( $link, $msg );
	}
	function cancellayout() {
		$returnid = MSHelper::__requestGetVarWrapper ( 'id' );
		$link = 'index.php?option=com_calcbuilder&controller=utility&' . JSession::getFormToken () . '=1&task=edit&cid[]=' . $returnid;
		$this->setRedirect ( $link );
	}
	
	/**
	 * cancel editing a record
	 * 
	 * @return void
	 */
	function cancel() {
		$msg = JText::_ ( 'OPERATION_CANCELLED' );
		$this->setRedirect ( 'index.php?option=com_calcbuilder&' . JSession::getFormToken () . '=1&controller=utility', $msg );
	}
	/*SHPInit1*/
	function excel() {
		$idutility = MSHelper::__requestGetVarWrapper ( 'idutility', 0 );
		$link = 'index.php?option=com_calcbuilder&controller=excel&class=1&' . JSession::getFormToken () . '=1&idobj=' . $idutility;
		$this->setRedirect ( $link );
	}
	/*SHPEnd1*/
	
}

?>
