<?php

/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */
// No direct access to this file
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class com_calcbuilderInstallerScript {
	/**
	 * method to install the component
	 *
	 * @return void
	 */
	function install($parent) {
		// echo 'Install';
	}
	
	/**
	 * method to uninstall the component
	 *
	 * @return void
	 */
	function uninstall($parent) {
		// $parent is the class calling this method
		echo '<p>Thanks for using Calc Builder</p>
    <p><hr/>If you have any question, problem or comment, please send us an email: <a href="mailto:gestion@moonsoft.es">gestion@moonsoft.es</a> or visit our web page <a href="http://www.moonsoft.es" target="_blank">www.moonsoft.es</a><br/>    
    </p>';
	}
	
	/**
	 * method to update the component
	 *
	 * @return void
	 */
	function update($parent) {
		// $parent is the class calling this method
		// echo '<h3>Updated</h3>';
	}
	
	/**
	 * method to run before an install/update/uninstall method
	 *
	 * @return void
	 */
	function preflight($type, $parent) {		
		if ($type != 'uninstall') {
			$jversion = new JVersion ();
			
			// Installing component manifest file version
			$this->release = $parent->get ( "manifest" )->version;
			
			// Manifest file minimum Joomla version
			$this->minimum_joomla_release = $parent->get ( "manifest" )->attributes ()->version;
			
			// abort if the current Joomla release is older
			if (version_compare ( $jversion->getShortVersion(), $this->minimum_joomla_release, 'lt' )) {
				Jerror::raiseWarning ( null, 'Cannot install this version of Calcbuilder ('.$jversion->getShortVersion().') in a Joomla release prior to ' . $this->minimum_joomla_release );
				return false;
			} else {
				$rel = $this->release;
			}
			
			// abort if the component being installed is not newer than the currently installed version
			if ($type == 'update') {
				$this->insertSchema ();
				$oldRelease = $this->getParam ( 'version' );
				$rel = $oldRelease . ' to ' . $this->release;
				if (version_compare ( $oldRelease, '2.1.0', 'lt' )) {
					Jerror::raiseWarning ( null, 'Incorrect version sequence. Cannot upgrade ' . $rel );
					return false;
				}
				$sql_updates = array ();
				if (version_compare ( $oldRelease, '2.1.1', 'lt' )) {
					$sql_updates [] = 'ALTER table `#__calcbuilder_field` add column `css` varchar(500) DEFAULT NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_field` add column `placeholder` varchar(500) DEFAULT NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_field` add column `mask` varchar(500) DEFAULT NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_field_multivalue` add column `ord` int(11) NOT NULL DEFAULT \'0\'';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `popupwidth` int(11) NOT NULL DEFAULT \'250\'';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `js_event_code` longtext';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `import_bootstrap` tinyint(4) NOT NULL DEFAULT \'1\'';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `datasave` tinyint(4) NOT NULL DEFAULT \'-1\'';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `calculate_button_text` varchar(500) NOT NULL DEFAULT \'\'';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `include_input` tinyint(4) NOT NULL DEFAULT \'0\'';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `include_result` tinyint(4) NOT NULL DEFAULT \'0\'';
					$sql_updates [] = 'CREATE TABLE IF NOT EXISTS `#__calcbuilder_userdata` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `iduser` int(11) NOT NULL,
					  `idutility` int(11) NOT NULL,
					  `data` longtext,
					  PRIMARY KEY (`id`)
					) DEFAULT CHARSET=utf8 AUTO_INCREMENT=1';
				}
				
				if (version_compare ( $oldRelease, '2.1.9', 'lt' )) {
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `mail_subject` VARCHAR(500) DEFAULT NULL ';
				}
				if (version_compare ( $oldRelease, '2.2.0', 'lt' )) {
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `calc_on_init` TINYINT NOT NULL DEFAULT 0 ';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `layout_position` TINYINT NOT NULL DEFAULT 0 ';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `form_layout_width` VARCHAR(45) NOT NULL DEFAULT \'100%\' ';
				}
				
				if (version_compare ( $oldRelease, '2.2.6', 'lt' )) {
					$sql_updates [] = 'ALTER table `#__calcbuilder_field` add column `combodependantfield` VARCHAR(500) NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_field` add column `combodependantsql` longtext NULL';
				}
				
				if (version_compare ( $oldRelease, '3.0.0', 'lt' )) {
					$sql_updates [] = '	CREATE TABLE IF NOT EXISTS `#__calcbuilder_excel` (
						`id` INT NOT NULL AUTO_INCREMENT,
						`idobj` INT NOT NULL,
						`excelfile` VARCHAR(250) NULL,
						`excelexec` TINYINT NOT NULL DEFAULT 0,
						`cache` TINYINT NOT NULL DEFAULT 0,
						`htmloutput` TINYINT NOT NULL DEFAULT 0,
  						`pdfoutput` TINYINT NOT NULL DEFAULT 0,
						`htmloutputpage` INT NOT NULL DEFAULT 0,
  						`pdfoutputpage` INT NOT NULL DEFAULT 0,
						`exceloutput` TINYINT NOT NULL DEFAULT 0,
						PRIMARY KEY (`id`)) DEFAULT CHARSET=utf8';
					$sql_updates [] = 'CREATE TABLE IF NOT EXISTS `#__calcbuilder_excel_mapping` (
						`id` INT NOT NULL AUTO_INCREMENT,
						`idexcel` INT NOT NULL,
						`type` TINYINT NOT NULL,
						`sheet` VARCHAR(150) NULL,
						`cell` VARCHAR(45) NULL,
						`phpvar` VARCHAR(150) NULL,
						PRIMARY KEY (`id`)) DEFAULT CHARSET=utf8';						
					
				}
				if (version_compare ( $oldRelease, '3.0.7', 'lt' )) {
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `sendemailcc` VARCHAR(500) NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `sendemailbcc` VARCHAR(500) NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `mc_api` VARCHAR(500) NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `mc_email` VARCHAR(500) NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `mc_list` VARCHAR(500) NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `mc_apply` TINYINT NOT NULL DEFAULT 0 ';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `mc_email_name` VARCHAR(150) NULL';
					$sql_updates [] = 'ALTER table `#__calcbuilder_utility` add column `mc_email_lastname` VARCHAR(150) NULL';
				}	
				if (version_compare ( $oldRelease, '3.1.5', 'lt' )) {
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_excel` ADD COLUMN `locale` VARCHAR(10) NOT NULL DEFAULT \'en_us\'';						
				}
				if (version_compare ( $oldRelease, '3.1.7', 'lt' )) {
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_utility` ADD COLUMN `sectionaddposition` TINYINT NOT NULL DEFAULT 0';
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_utility` ADD COLUMN `precalcprintpdf` LONGTEXT NOT NULL DEFAULT ""';
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_utility` ADD COLUMN `poscalcprintpdf` LONGTEXT NOT NULL DEFAULT ""';					
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_utility` ADD COLUMN `include_input_pdf` TINYINT NOT NULL DEFAULT 0 ';
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_utility` ADD COLUMN `include_result_pdf` TINYINT NOT NULL DEFAULT 0 ';
					$sql_updates [] = 'UPDATE `#__calcbuilder_utility` SET 	precalcprintpdf=precalcprint,poscalcprintpdf=poscalcprint,include_input_pdf=include_input,include_result_pdf=include_result';
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_utility` ADD COLUMN `emailaddpdf` TINYINT NOT NULL DEFAULT 0 ';
				}
				if (version_compare ( $oldRelease, '3.1.8', 'lt' )) {
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_utility` ADD COLUMN `sectionposition` TINYINT NOT NULL DEFAULT 0 ';
				}
				
				if (version_compare ( $oldRelease, '3.1.9', 'lt' )) {
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_field` ADD COLUMN `inlineevent` TINYINT NOT NULL DEFAULT 0 ';
					$sql_updates [] = 'UPDATE `#__calcbuilder_field` SET `inlineevent`=1 ';
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_section` ADD COLUMN `addinlineevent` TINYINT NOT NULL DEFAULT 0 ';					
					$sql_updates [] = 'ALTER TABLE `#__calcbuilder_section` ADD COLUMN `delinlineevent` TINYINT NOT NULL DEFAULT 0 ';						
				}				
												
				$db = JFactory::getDbo ();
				foreach ( $sql_updates as $sql ) {
					$db->setQuery ( $sql );
					$db->query ();
				}
			} else {
				$rel = $this->release;
			}
		}
	}
	
	/**
	 * method to run after an install/update/uninstall method
	 *
	 * @return void
	 */
	function postflight($type, $parent) {
		if ($type != 'uninstall') {
			$jversion = new JVersion ();
			if (version_compare ( $jversion->getShortVersion (), '2.5.5', 'lt' )) {
				rename ( JPATH_ADMINISTRATOR . '/components/com_calcbuilder/controller_16.php', JPATH_ADMINISTRATOR . '/components/com_calcbuilder/controller.php' );
				rename ( JPATH_ADMINISTRATOR . '/components/com_calcbuilder/helper_16.php', JPATH_ADMINISTRATOR . '/components/com_calcbuilder/helper.php' );
				rename ( JPATH_ADMINISTRATOR . '/components/com_calcbuilder/models/main.model_16.php', JPATH_ADMINISTRATOR . '/components/com_calcbuilder/models/main.model.php' );
				rename ( JPATH_ADMINISTRATOR . '/components/com_calcbuilder/views/main.view_16.php', JPATH_ADMINISTRATOR . '/components/com_calcbuilder/views/main.view.php' );
				rename ( JPATH_SITE . '/components/com_calcbuilder/models/main.model_16.php', JPATH_SITE . '/components/com_calcbuilder/models/main.model.php' );
			}
		}
	}
	
	/*
	 * get a variable from the manifest file (actually, from the manifest cache).
	 */
	function getParam($name) {
		$db = JFactory::getDbo ();
		$db->setQuery ( 'SELECT manifest_cache FROM #__extensions WHERE element = "com_calcbuilder" and type="component"' );
		$manifest = json_decode ( $db->loadResult (), true );
		return $manifest [$name];
	}
	
	/*
	 * sets parameter values in the component's row of the extension table
	 */
	function setParams($param_array) {
		if (count ( $param_array ) > 0) {
			// read the existing component value(s)
			$db = JFactory::getDbo ();
			$db->setQuery ( 'SELECT params FROM #__extensions WHERE element = "com_calcbuilder"  and type="component"' );
			$params = json_decode ( $db->loadResult (), true );
			// add the new variable(s) to the existing one(s)
			foreach ( $param_array as $name => $value ) {
				$params [( string ) $name] = ( string ) $value;
			}
			// store the combined new and existing values back as a JSON string
			$paramsString = json_encode ( $params );
			$db->setQuery ( 'UPDATE #__extensions SET params = ' . $db->quote ( $paramsString ) . ' WHERE element = "com_calcbuilder" and type="component"' );
			$db->query ();
		}
	}
	
	/* insert schema entry if not present */
	function insertSchema() {
		$db = JFactory::getDbo ();
		$db->setQuery ( 'select count(*) from #__schemas where extension_id=(select extension_id from #__extensions WHERE element = "com_calcbuilder"  and type="component")' );
		$entrada = $db->loadResult ();
		$db->setQuery ( 'select count(*) from #__extensions WHERE element = "com_calcbuilder"  and type="component"' );
		$extensions = $db->loadResult ();
		// extension_id
		if ($entrada == "0" && $extensions != "0") {
			$db->setQuery ( 'insert into #__schemas (extension_id,version_id) values ((select extension_id from #__extensions WHERE element = "com_calcbuilder"  and type="component"),"2.1.0") ' );
			$db->query ();
		}
	}
}

?>