<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// Check to ensure this file is included in Joomla!
defined ( '_JEXEC' ) or die ();

jimport ( 'joomla.application.component.model' );
jimport('joomla.filesystem.file');

require 'wrapper.model.php';
class CalcbuilderModelExcel extends wrapperMainModel {
	var $_id;
	var $_pageNav;
	
	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access public
	 * @return void
	 */
	function __construct() {
		parent::__construct ();
		$this->_id = null;
		$array = MSHelper::__requestGetVarWrapper ( 'cid', - 1, '', 'array' );
		/*
		 * $_class = MSHelper::__requestGetVarWrapper('class', -1); $_obj = MSHelper::__requestGetVarWrapper('obj', -1);
		 */
		$this->setId ( ( int ) $array [0] );
	}	
	function setId($id) {
		$this->_id = $id;
	}
	function getPageNav() {
		return $this->_pageNav;
	}
	
	function getExcelData(){
		$idobj=MSHelper::__requestGetVarWrapper('idobj',null);
		$data=array();
		$data['excel']=$this->getExcelWrapper($idobj);
		if (isset($data['excel']))
			$data['mapping']=$this->getExcelMappingWrapper($data['excel']->id);
		return $data;
	}

	private function getExcelWrapper($idobj){		
		return $this->_getTableObject('#__calcbuilder_excel','idobj='.$idobj)->getProperty('data');
	}
	
	private function getExcelMappingWrapper($idexcel){
		return $this->_getTableObject('#__calcbuilder_excel_mapping','idexcel='.$idexcel,null,true)->getProperty('data');
	}	
	
	function store() {		
		$id=MSHelper::__requestGetVarWrapper('id',null);
		$idexcel;
		// Upload file
		$importfile = MSHelper::__requestGetVarWrapper ( 'excelfile', null, 'files', 'array' );
		//var_dump($importfile);
		$data=$_POST;
		$filename='';
		if (isset($importfile)) :
			$filename = rand(1000, 9999).'_'.JFile::makeSafe ( $importfile ['name'] );
			if ($importfile ['name']!='') :
				$src = $importfile['tmp_name'];
				$dest = JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$filename;
				JFile::upload($src, $dest);
				$data['excelfile']=$filename;
			endif;			
		else:
			unset($data['excelfile']);
		endif;
		if ($id!=null&&$id!=''):
			$idexcel=$this->_storeArray('#__calcbuilder_excel',$data,true,'id');		
		else:
			$idexcel=$this->_storeArray('#__calcbuilder_excel',$data);
		endif;
		// Mapping
		$mapping=MSHelper::__requestGetVarWrapper('mapping',null);
		if ($mapping!=null):
			$this->_delete('#__calcbuilder_excel_mapping','idexcel='.$idexcel);
			$mappingdec=json_decode($mapping);			
			$inputMapping=$mappingdec->input;			
			foreach ($inputMapping as $mapping):
				$mapping->type=0;
				$mapping->idexcel=$idexcel;
				$this->_storeArray('#__calcbuilder_excel_mapping', (array)$mapping);
			endforeach;
			$outputMapping=$mappingdec->output;			
			foreach ($outputMapping as $mapping):
				$mapping->type=1;
				$mapping->idexcel=$idexcel;
				$this->_storeArray('#__calcbuilder_excel_mapping', (array)$mapping);
			endforeach;
		endif;		
		return $idexcel;
	}	
}

?>
