<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// Check to ensure this file is included in Joomla!
defined ( '_JEXEC' ) or die ();

jimport ( 'joomla.application.component.model' );

require 'wrapper.model.php';
class CalcbuilderModelStats extends wrapperMainModel {
	var $_id;
	var $_pageNav;
	
	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access public
	 * @return void
	 */
	function __construct() {
		parent::__construct ();
		$this->_id = null;
		$array = MSHelper::__requestGetVarWrapper ( 'cid', - 1, '', 'array' );
		$this->setId ( ( int ) $array [0] );
	}
	function setId($id) {
		$this->_id = $id;
	}
	function getPageNav() {
		return $this->_pageNav;
	}
	
	/**
	 * Returns the query
	 * 
	 * @return string The query to be used to retrieve the rows from the database
	 */
	function _buildQuerySelect() {
		$query = "select idobj, count(distinct(idrequest)) as req 
        	from #__calcbuilder_stats group by idobj";
		return $query;
	}
	function _buildQuerySelectIdboj($id = null) {
		$query = "select idobj, idrequest, field, value 
        	from #__calcbuilder_stats ";
		if ($id != null) {
			if (! is_numeric ( $id ))
				JError::raiseError ( 500, JText::_ ( 'INTERNAL SERVER ERROR' ) );
			$query .= " where idobj=" . $id;
		}
		$query .= " order by idobj, idrequest";
		return $query;
	}
	function _buildQuerySelectUtilityName($id) {
		if (! is_numeric ( $id ))
			JError::raiseError ( 500, JText::_ ( 'INTERNAL SERVER ERROR' ) );
		$query = "select name from #__calcbuilder_utility where id=" . $id;
		return $query;
	}
	function _buildQuerySelectUtilityNameValue() {
		$query = "select id, name from #__calcbuilder_utility";
		return $query;
	}
	function _buildQueryCalcs() {
		$query = "select distinct(idobj) as ids from #__calcbuilder_stats";
		return $query;
	}
	function _buildQueryFieldsCalc($id) {
		if (! is_numeric ( $id ))
			JError::raiseError ( 500, JText::_ ( 'INTERNAL SERVER ERROR' ) );
		$query = "select distinct(field) as field from #__calcbuilder_stats where idobj=" . $id;
		return $query;
	}
	function _buildQueryCalcFieldStats($id, $fieldname) {
		if (! is_numeric ( $id ))
			JError::raiseError ( 500, JText::_ ( 'INTERNAL SERVER ERROR' ) );
		$db = JFactory::getDBO ();
		$query = "select value,count(value) as req  
    		from #__calcbuilder_stats where idobj=" . $id . " and field=" . $db->quote($fieldname) . " group by value";
		return $query;
	}
	function _buildDeleteStats() {
		$query = "delete from #__calcbuilder_stats";
		return $query;
	}
	function getData() {
		$db = JFactory::getDBO ();
		$query = $this->_buildQuerySelect ();
		$db->setQuery ( $query );
		$data = $db->loadObjectList ();
		$retorno = array ();
		foreach ( $data as $elem ) {
			$id = $elem->idobj;
			$query = $this->_buildQuerySelectUtilityName ( $id );
			$db->setQuery ( $query );
			$elemint = $db->loadResult ();
			$retorno [$elemint] = $elem->req;
		}
		return $retorno;
	}
	function getStatsPerCalc() {
		$db = JFactory::getDBO ();
		$query = $this->_buildQueryCalcs ();
		$db->setQuery ( $query );
		$calcs = $db->loadColumn ();
		$retorno = array ();
		for($i = 0; $i < count ( $calcs ); $i ++) {
			$calc = $calcs [$i];
			$query = $this->_buildQueryFieldsCalc ( $calc );
			$db->setQuery ( $query );
			$calcfields = $db->loadObjectList ();
			$arrField = array ();
			for($j = 0; $j < count ( $calcfields ); $j ++) {
				$query = $this->_buildQueryCalcFieldStats ( $calc, $calcfields [$j]->field );
				$db->setQuery ( $query );
				$arrField [$calcfields [$j]->field] = $db->loadObjectList ();
			}
			$query = $this->_buildQuerySelectUtilityName ( $calc );
			$db->setQuery ( $query );
			$calcName = $db->loadResult ();
			$retorno [$calcName] = $arrField;
		}
		return $retorno;
	}
	function getStatsExport() {
		$calc = MSHelper::__requestGetVarWrapper ( 'idcalc', - 1 );
		$db = JFactory::getDBO ();
		$retorno = array ();
		$query = $this->_buildQuerySelectIdboj ( $calc );
		$db->setQuery ( $query );
		$data = $db->loadObjectList ();
		foreach ( $data as $elem ) {
			$retorno [$elem->idrequest] [$elem->field] = $elem->value;
		}
		return $retorno;
	}
	function getDatagrid() {
		$db = JFactory::getDBO ();
		$retorno = array ();
		$query = $this->_buildQuerySelectIdboj ();
		$db->setQuery ( $query );
		$data = $db->loadObjectList ();
		foreach ( $data as $elem ) {
			$retorno [$elem->idobj] [$elem->idrequest] [$elem->field] = $elem->value;
		}
		return $retorno;
	}
	function getDataUtility() {
		$db = JFactory::getDBO ();
		$retorno = array ();
		$query = $this->_buildQuerySelectUtilityNameValue ();
		$db->setQuery ( $query );
		return $db->loadAssocList ( 'name' );
	}
	function getDatagridFields() {
		$db = JFactory::getDBO ();
		$query = $this->_buildQuerySelect ();
		$db->setQuery ( $query );
		$data = $db->loadObjectList ();
		$retorno = array ();
		foreach ( $data as $elem ) {
			$id = $elem->idobj;
			$query = $this->_buildQueryFieldsCalc ( $id );
			$db->setQuery ( $query );
			$retorno [$id] = $db->loadColumn ();
		}
		return $retorno;
	}
	function getDatagridFieldsExport() {
		$calc = MSHelper::__requestGetVarWrapper ( 'idcalc', - 1 );
		$db = JFactory::getDBO ();
		$query = $this->_buildQueryFieldsCalc ( $calc );
		$db->setQuery ( $query );
		return $db->loadColumn ();
	}
	function reset() {
		$db = JFactory::getDBO ();
		$query = $this->_buildDeleteStats ();
		$db->setQuery ( $query );
		if (! $db->query ()) {
			$this->setError ( $db->getError () );
			return false;
		}
		return true;
	}
}

?>
