<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// No direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );

jimport ( 'joomla.application.component.view' );

require JPATH_COMPONENT_ADMINISTRATOR . '/views/wrapper.view.php';
class CalcbuilderViewExcel extends wrapperMainView {
	protected $permissions;
	function display($tpl = null) {
		$this->permissions = $this->getActions ();
		$layout = $this->getLayout ();
		switch ($layout) {
			case 'default' :
				$excel = $this->get ( 'ExcelData' );
				$this->assignRef ( 'excel', $excel );
				break;			
			default :
				break;
		}
		// Set the toolbar
		$this->addToolbar ();
		parent::display ( $tpl );
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since 1.6
	 */
	protected function addToolbar() {
		$document = JFactory::getDocument ();
		$document->addStyleDeclaration ( '.icon-48-calcbuilderexcel{background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/CalcBuilderExcel.png)}' );
		$layout = $this->getLayout ();
		switch ($layout) {
			case 'default' :
				JToolBarHelper::title ( JText::_ ( 'EXCEL' ) , 'calcbuilderexcel' );
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::apply ();
					JToolBarHelper::save ();
				}
				JToolBarHelper::cancel ( 'cancel', JText::_ ( 'CLOSE' ) );
				break;			
		}
	}
}

?>
