<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// No direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );

jimport ( 'joomla.application.component.view' );

require JPATH_COMPONENT_ADMINISTRATOR . '/views/wrapper.view.php';
class CalcbuilderViewMatrix extends wrapperMainView {
	protected $permissions;
	/**
	 * display method of Hello view
	 * 
	 * @return void
	 *
	 */
	function display($tpl = null) {
		$this->permissions = $this->getActions ();
		$layout = $this->getLayout ();
		$idobj = $this->get ( 'Idobj' );
		$class = $this->get ( 'Class' );
		$dscobj = $this->get ( 'DscObj' );
		$lists ['idobj'] = $idobj;
		$lists ['class'] = $class;
		switch ($layout) {
			case 'default' :
				$solutions = $this->get ( 'Data' );
				$pageNav = $this->get ( 'PageNav' );
				$this->assignRef ( 'items', $solutions );
				$this->assignRef ( 'pagenav', $pageNav );
				$this->assignRef ( 'lists', $lists );
				break;
			case 'edit' :
				$target = $this->get ( 'DataOne' );
				$this->assignRef ( 'item', $target );
				$this->assignRef ( 'lists', $lists );
				break;
			default :
				break;
		}
		// Set the toolbar
		$this->addToolbar ( $dscobj, $class );
		parent::display ( $tpl );
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since 1.6
	 */
	protected function addToolbar($dscobj, $class) {
		$document = JFactory::getDocument ();
		$document->addStyleDeclaration ( '.icon-48-calcbuildermatrix {background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/CalcBuilderMatrix.png)}' );
		$layout = $this->getLayout ();
		switch ($layout) {
			case 'default' :
				JToolBarHelper::title ( $dscobj . ' ' . JText::_ ( 'MATRIX' ) . ': <small><small>' . JText::_ ( 'LIST' ) . '</small></small>', 'calcbuildermatrix' );
				JToolBarHelper::custom ( 'volver', 'back', 'back', JText::_ ( 'UTILITIES' ), false, false );
				JToolBarHelper::deleteList ();
				JToolBarHelper::editList ( 'edit' );
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::addNew ( 'add' );
				}
				break;
			case 'edit' :
				JToolBarHelper::title ( $dscobj . ' ' . JText::_ ( 'MATRIX' ) . ': <small><small>[ ' . JText::_ ( 'EDIT' ) . ' ]</small></small>', 'calcbuildermatrix' );
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::apply ();
					JToolBarHelper::save ();
				}
				JToolBarHelper::cancel ( 'cancel', JText::_ ( 'CLOSE' ) );
				break;
			case 'new' :
				JToolBarHelper::title ( $dscobj . ' ' . JText::_ ( 'MATRIX' ) . ': <small><small>[ ' . JText::_ ( 'NEW' ) . ' ]</small></small>', 'calcbuildermatrix' );
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::apply ();
					JToolBarHelper::save ();
				}
				JToolBarHelper::cancel ();
				break;
		}
	}
}

?>
