<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// No direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );

jimport ( 'joomla.application.component.view' );

require JPATH_COMPONENT_ADMINISTRATOR . '/views/wrapper.view.php';
class CalcbuilderViewUtility extends wrapperMainView {
	protected $permissions;
	function display($tpl = null) {
		$this->permissions = $this->getActions ();
		$layout = $this->getLayout ();
		switch ($layout) {
			case 'default' :
				$utilities = $this->get ( 'Data' );
				$pageNav = $this->get ( 'PageNav' );
				$this->assignRef ( 'items', $utilities );
				$this->assignRef ( 'pagenav', $pageNav );
				$this->assignRef ( 'permissions', $this->permissions );
				break;
			case 'layout':
	          	/*$fieldslayout =&$this->get('DataFieldsLayout');
	            $this->assignRef('fieldslayout', $fieldslayout);
	            $layoutpreference =&$this->get('DataLayoutPreference');
	            $this->assignRef('layoutpreference', $layoutpreference);*/          	
	          	$sections = $this->get ( 'DataSections' );
				$this->assignRef ( 'sections', $sections );
				$allfields = $this->get ( 'DataAllFieldsLayout' );
				$this->assignRef ( 'allfields', $allfields );
			case 'edit' :
				$utility = $this->get ( 'DataOne' );
				$fields = $this->get ( 'DataFields' );
				// $events=$this->get('DataEvents');
				$sections = $this->get ( 'DataSections' );
				$multivalues = $this->get ( 'Multivalues' );
				$vmproducts = $this->get ( 'Vmproducts' );
				$this->assignRef ( 'item', $utility );
				$this->assignRef ( 'fields', $fields );
				// $this->assignRef('events', $events);
				$this->assignRef ( 'sections', $sections );
				$this->assignRef ( 'multivalues', $multivalues );
				$this->assignRef ( 'vmproducts', $vmproducts );
				break;
			case 'exitlayout' :
				$utility = $this->get ( 'DataOne' );
				$this->assignRef ( 'item', $utility );
				$allfields = $this->get ( 'DataAllFieldsLayout' );
				$this->assignRef ( 'allfields', $allfields );
			default :
				break;
		}
		// Set the toolbar
		$this->addToolbar ();
		parent::display ( $tpl );
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since 1.6
	 */
	protected function addToolbar() {
		$document = JFactory::getDocument ();
		$document->addStyleDeclaration ( '.icon-48-calcbuilderutility {background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/CalcBuilderUtility.png)}' );
		$document->addStyleDeclaration ( '.icon-48-calcbuilder {background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/CalcBuilder48x48.png)}' );
		$document->addStyleDeclaration ( '.icon-32-stats {background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/stats.png)}' );
		$document->addStyleDeclaration ( '.icon-32-layout {background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/form_layout.png)}' );
		$document->addStyleDeclaration ( '.icon-32-exitlayout {background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/exit_layout2.png)}' );
		$document->addStyleDeclaration ( '.icon-32-matrix {background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/matrix.png)}' );
		$document->addStyleDeclaration ( '.icon-32-import {background-image: url(' . JURI::base () . 'components/com_calcbuilder/assets/img/import.png)}' );
		/*SHPInit1*/
		$document->addStyleDeclaration('.icon-32-excel {background-image: url('.JURI::base().'components/com_calcbuilder/assets/img/excel.png)}');
		/*SHPEnd1*/
		$layout = $this->getLayout ();
		switch ($layout) {
			case 'default' :
				JToolBarHelper::title ( JText::_ ( 'UTILITIES' ) . ': <small><small>' . JText::_ ( 'LIST' ) . '</small></small>', 'calcbuilder' );
				// JToolBarHelper::custom( 'export', 'archive', 'archive', JText::_( "EXPORT" ), true, false );
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::custom ( 'import', 'import', 'import', JText::_ ( "IMPORT" ), false, false );
				}
				if ($this->permissions->get ( 'calc.stats' )) {
					JToolBarHelper::custom ( 'stats', 'stats', 'stats', JText::_ ( "STATS" ), false, false );
				}
				JToolBarHelper::spacer ();
				JToolBarHelper::divider ();
				JToolBarHelper::spacer ();
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::deleteList ();
				}
				if ($this->permissions->get ( 'core.edit' )) {
					JToolBarHelper::editList ( 'edit' );
				}
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::addNew ( 'add' );
				}
				break;
			case 'edit' :
				JToolBarHelper::title ( JText::_ ( 'UTILITIES' ) . ': <small><small>' . JText::_ ( 'EDIT' ) . '</small></small>', 'calcbuilderutility' );
				/*SHPInit2*/
				JToolBarHelper::custom ( 'excel', 'excel', 'excel', JText::_ ( "EXCEL" ), false, false );
				/*SHPEnd2*/
				JToolBarHelper::custom ( 'layout', 'layout', 'layout', JText::_ ( "FORMLAYOUT" ), false, false );
				JToolBarHelper::custom ( 'exitlayout', 'exitlayout', 'exitlayout', JText::_ ( "EXITLAYOUT" ), false, false );
				JToolBarHelper::custom ( 'matrix', 'matrix', 'matrix', JText::_ ( "MATRIX" ), false, false );
				JToolBarHelper::spacer ();
				JToolBarHelper::divider ();
				JToolBarHelper::spacer ();
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::apply ();
					JToolBarHelper::save ();
				}
				JToolBarHelper::cancel ( 'cancel', JText::_ ( 'CLOSE' ) );
				break;
			case 'new' :
				JToolBarHelper::title ( JText::_ ( 'UTILITIES' ) . ': <small><small>' . JText::_ ( 'NEW' ) . '</small></small>', 'calcbuilderutility' );
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::apply ();
					JToolBarHelper::save ();
				}
				JToolBarHelper::cancel ();
				break;
			case 'import' :
				JToolBarHelper::title ( JText::_ ( 'UTILITIES' ) . ': <small><small>' . JText::_ ( 'IMPORT' ) . '</small></small>', 'calcbuilder' );
				JToolBarHelper::custom ( 'volver', 'back', 'back', JText::_ ( 'UTILITIES' ), false, false );
				break;
			case 'layout' :
				JToolBarHelper::title ( JText::_ ( 'UTILITIES' ) . ': <small><small>' . JText::_ ( 'FORMLAYOUT' ) . '</small></small>', 'calcbuilder' );
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::apply ( 'applylayout' );
					JToolBarHelper::save ( 'savelayout' );
				}
				JToolBarHelper::cancel ( 'cancellayout', JText::_ ( 'CLOSE' ) );
				break;
			case 'exitlayout' :
				JToolBarHelper::title ( JText::_ ( 'UTILITIES' ) . ': <small><small>' . JText::_ ( 'EXITLAYOUT' ) . '</small></small>', 'calcbuilder' );
				if ($this->permissions->get ( 'core.admin' )) {
					JToolBarHelper::apply ( 'applyexitlayout' );
					JToolBarHelper::save ( 'saveexitlayout' );
				}
				JToolBarHelper::cancel ( 'cancellayout', JText::_ ( 'CLOSE' ) );
				break;
		}
	}
	
	/**
	 *
	 * @param string $comString        	
	 * @param string $validationType:<br>
	 *        	100 => 1st char = validate db?<br>
	 *        	010 => 2nd char = validate backend folder?<br>
	 *        	001 => 3rd char = validate frontend folder?<br>
	 *        	111 => validate all example<br>
	 */
	public function validateComponent($comString, $validationType = 100) {
		jimport ( 'joomla.filesystem.folder' );
		// default result
		$validComponent = false;
		$validationsDone = 0;
		// use allways as string
		$validationType = ( string ) $validationType;
		// get required validations
		$validateDb = (isset ( $validationType [0] ) && $validationType [0] == '1');
		$validateBackend = (isset ( $validationType [1] ) && $validationType [1] == '1');
		$validateFrontend = (isset ( $validationType [2] ) && $validationType [2] == '1');
		// validate: extension is present and enabled on db
		if (($validationsDone == 0 || ($validComponent)) && $validateDb) {
			$db = JFactory::getDbo ();
			$query = $db->getQuery ( true );
			$query->select ( 'extension_id, name' );
			$query->from ( '#__extensions' );
			$query->where ( 'name=' . $db->quote ( $comString ) );
			$db->setQuery ( $query );
			if ($db->loadObject ()) {
				$validComponent = true;
			} else {
				$validComponent = false;
			}
			$validationsDone ++;
		}
		// validate: backend folder exist
		if (($validationsDone == 0 || ($validComponent)) && $validateBackend) {
			$backendPath = JPATH_ADMINISTRATOR . DS . 'components' . DS . $comString;
			$validComponent = JFolder::exists ( $backendPath );
			$validationsDone ++;
		}
		// validate: frontend folder exist
		if (($validationsDone == 0 || ($validComponent)) && $validateFrontend) {
			$frontendPath = JPATH_SITE . DS . 'components' . DS . $comString;
			$validComponent = JFolder::exists ( $frontendPath );
			$validationsDone ++;
		}
		return $validComponent;
	}
}

?>
