<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */
 
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.model' );
//import joomlas filesystem functions, we will do all the filewriting with joomlas functions,
//so if the ftp layer is on, joomla will write with that, not the apache user, which might
//not have the correct permissions
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');
jimport('joomla.application.input.cookie');


require 'wrapper.model.php';
include JPATH_ADMINISTRATOR .DS.'components'.DS.'com_calcbuilder'.DS.'lib'. DS . 'mailchimp.php';
/*SHPInit6*/
include 'vm_cb_class.php';
require_once (JPATH_SITE .DS.'components'.DS.'com_calcbuilder'.DS.'views'.DS. 'calcbuilder'.DS. 'mpdf'.DS. 'mpdf.php');
/*SHPEnd6*/

class CalcbuilderModelCalcbuilder extends wrapperMainModel{

	const TYPE_CALC=0;
	const TYPE_PDF=1;
	const TYPE_EXCEL=2;
	const TYPE_EMAIL=3;

	var $_data;
	var $_type=CalcbuilderModelCalcbuilder::TYPE_CALC;
	var $_stats_added=array();

	function _buildQuerySelect($id=null){
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$db =JFactory::getDBO();
		$query = "select * from #__calcbuilder_utility ";
		if ($id!=null){
			if (is_numeric($id)) $query .= 'where id='.$id;
			else JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		}
		return $query;
	}


	function _buildQuerySelectFieldsOne($id,$class=1,$type=null){
		$db =JFactory::getDBO();
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select *
          from #__calcbuilder_field  where idobj=".$id." and class=".$class;
		if ($type!=null) $query .= ' and type='.$type;
		$query.=" order by `order` asc";
		return $query;
	}

	function _buildQueryFieldsWOOrder($id=null,$class=1){
		$db =JFactory::getDBO();
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select f.*
          from #__calcbuilder_field f
          where f.class=".$class;
		if ($id!=null) $query .= ' and f.idobj='.$id;
		return $query;
	}

	function _buildQueryFieldById($id){
		$db =JFactory::getDBO();
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select f.* from #__calcbuilder_field f where f.id=".$id;
		return $query;
	}

	function _buildQueryMatrix($id=null,$main=0){
		$db =JFactory::getDBO();
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select m.*
          from #__calcbuilder_matrix m
          where m.class=1 and m.idobj=".$id."
          and m.main=".$main;
		return $query;
	}

	function _buildQuerySelectSection($id){
		$db =JFactory::getDBO();
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select f.idfield as fields from #__calcbuilder_section s left join #__calcbuilder_section_field f on s.id=f.idsection
        			where s.idutility=".$id;
		return $query;
	}

	function _buildQuerySelectSectionLayout($id){
		$db =JFactory::getDBO();
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select s.*,group_concat(f.idfield) as fields from #__calcbuilder_section s left join #__calcbuilder_section_field f on s.id=f.idsection
        			where s.idutility=".$id." group by s.id";
		return $query;
	}

	function _buildQuerySelectMultivalue($id){
		$db = JFactory::getDBO();
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select * from #__calcbuilder_field_multivalue where id=".$id;
		return $query;
	}

	function _buildQuerySelectIdUserData($iduser){
		$db = JFactory::getDBO();
		if (!is_numeric($iduser)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select id from #__calcbuilder_userdata where iduser=".$iduser;
		return $query;
	}

	function getMultivalue($id){
		//if ($id=='') return null;
		$db =JFactory::getDBO();
		$query = $this->_buildQuerySelectMultivalue($id);
		$db->setQuery($query);
		return $db->loadObject();
	}



	function getNameMultivalue($multivalue,$id){
		$arrElements=explode('&',$multivalue);
		foreach ($arrElements as $elem) {
			$elemSeparator=explode('#',$elem);
			if ($elemSeparator[1]==$id)
				return $elemSeparator[0];
		}
		return '';
	}
	function addToStats($field=null,$value=null){
		$stats_temp=array();
		$stats_temp[]=$field;
		$stats_temp[]=$value;
		$this->_stats_added[]=$stats_temp;
	}
	function setUserData($datasave){
		switch($datasave){
			case '0':
				$user=JFactory::getUser();
				if ($user->guest) break;
				$db =JFactory::getDBO();
				$data['idutility']=MSHelper::__requestGetVarWrapper('id');
				$data['iduser']=$user->id;
				$data['data']=MSHelper::__requestGetVarWrapper('cb_alldata');
				$row =$this->getTable('userdata');
				$idRow=$this->getUserDataId($data['iduser']);
				if($idRow!=null && $idRow!='') $row->load($idRow);
				if (!$row->bind($data)) {
					$this->setError($row->getError());
					return false;
				}
				if (!$row->check()) {
					$this->setError($row->getError());
					return false;
				}
				if (!$row->store()) {
					$this->setError($row->getError());
					return false;
				}
				break;
			case '1':
				setcookie('cb_alldata_'.MSHelper::__requestGetVarWrapper('id'),MSHelper::__requestGetVarWrapper('cb_alldata'));
				break;
		}
	}

	function getUserDataId($iduser){
		$db =JFactory::getDBO();
		$query = $this->_buildQuerySelectIdUserData($iduser);
		$db->setQuery($query);
		return $db->loadResult();
	}

	function setStats($utility, $_vars){
		$db =JFactory::getDBO();
		$_id = MSHelper::__requestGetVarWrapper('id');
		$_query = $this->_buildQuerySelectSection($_id);
		$db->setQuery( $_query);
		$_sectionfields=$db->loadColumn();
		$_sessioncb = JFactory::getSession();
		 
		$time=time();
		foreach ($_vars as $_var) {
			$_result=array();
			$_result['idobj']=$utility->id;
			$_result['idrequest']=$time;
			$_name=$_var->name;
			$_valid=true;
			if ($_var->type=='9') $_valid=false;
			$_value='';
			if ($_valid){
				$_value='';
				if ($_var->type=='11'){
					$_attach_store[]='imageUpload_'.$_var->id;
					$_attach_store[]='imageUpload_http_'.$_var->id;
					$_attach[]=$_sessioncb->get('imageUpload_'.$_var->id);
					$_file_tmp = $_sessioncb->get('imageUpload_http_'.$_var->id);
					$_tmp_value='';
					if($_file_tmp!=null && isset($_file_tmp) && count($_file_tmp)>0){
						foreach ($_file_tmp as $f){
							$_value.='<a href="'.$f.'" target="_blank">'.$f.'</a><br />';
						}
					}
				} elseif ($_var->type=='7' || in_array($_var->id, $_sectionfields)){
					$_value=MSHelper::__requestGetVarWrapper('fld_'.$_var->id, array(), '', 'array');
					$_stringvalues=array();
					if ($_var->type=='2' || $_var->type=='6' || $_var->type=='7' || $_var->type=='12'){
						foreach ($_value as $_valueInt){
							if ($_var->sqltext!=null && trim($_var->sqltext)!=''){
								$_mv=$_valueInt;
							} elseif($_valueInt!=''){
								$_mv=$this->getMultivalue($_valueInt);
								if (isset($_mv)) $_stringvalues[]=$_mv->name;
							}else {
								$_stringvalues[]='';
							}
						}
					} else {
						foreach ($_value as $_valueInt){
							$_stringvalues[]=$_valueInt;
						}
					}
					$_value=implode(' - ',$_stringvalues);
				} elseif ($_var->type=='2' || $_var->type=='6' || $_var->type=='12'){
					$_valuetmp=MSHelper::__requestGetVarWrapper('fld_'.$_var->id);
					if ($_valuetmp!=''&&is_numeric($_valuetmp)){
						if ($_var->sqltext!=null && trim($_var->sqltext)!=''){
							$_mv=$_valueInt;
						} else{
							$_mv=$this->getMultivalue($_valuetmp);
							if (isset ($_mv)){
								$_value=$_mv->name;
							} else {
								$_value='';
							}
						}
					} else {
						$_value='';
					}
				} else {
					$_value=MSHelper::__requestGetVarWrapper('fld_'.$_var->id);
				}

				if (is_array($_value)) $_value=implode(' - ',$_value);
				$value=trim($_value);

				$_result['field']=$_name;
				$_result['value']=$value;
				$row =$this->getTable('stats');
				if (!$row->bind($_result)) {
					$this->setError($row->getError());
					return false;
				}
				if (!$row->check()) {
					$this->setError($row->getError());
					return false;
				}
				if (!$row->store()) {
					$this->setError($row->getError());
					return false;
				}
			}
			 
		}
		foreach($this->_stats_added as $stats){
			$_result=array();
			$_result['idobj']=$utility->id;
			$_result['idrequest']=$time;
			$_result['field']=$stats[0];
			$_result['value']=$stats[1];
			$row =$this->getTable('stats');
			if (!$row->bind($_result)) {
				$this->setError($row->getError());
				return false;
			}
			if (!$row->check()) {
				$this->setError($row->getError());
				return false;
			}
			if (!$row->store()) {
				$this->setError($row->getError());
				return false;
			}
		}
		 
	}


	function getCalculo(){
		$this->_type=$this::TYPE_CALC;
		return $this->getCalculoWrapper(true);
	}

	function getCalculoEmailPDF(){
		$this->_type=$this::TYPE_PDF;
		return $this->getCalculoWrapper(false);
	}

	function getCalculoEmailExcel(){
		$this->_type=$this::TYPE_EXCEL;
		return $this->getCalculoWrapper(false);
	}

	function getCalculator($_id){
		$_db =JFactory::getDBO();
		$_query = $this->_buildQuerySelect($_id);
		$_db->setQuery( $_query);
		return $_db->loadObject();
	}

	function getCalculoWrapper($sendEmail=true, $ishkplugin=false){
		$_sessioncb = JFactory::getSession();
		//$_data = JRequest::get('post');
		$_attach=array();
		$_attach_store=array();

		$_id = MSHelper::__requestGetVarWrapper('id');
		$_db =JFactory::getDBO();
		/*$_query = $this->_buildQueryMatrix($_id,0);
		 $_db->setQuery( $_query);
		$_matrices=$_db->loadObjectList();*/

		$_solution=$this->getCalculator($_id);

		$_query = $this->_buildQueryFieldsWOOrder($_id,1);
		$_db->setQuery($_query);
		$_vars=$_db->loadObjectList();
		$_arrVars=array();

		/*$_query = $this->_buildQueryMatrix($_id,1);
		 $_db->setQuery( $_query);
		$_matrizfinal=$_db->loadObject();*/
		/*
		 $_query = $this->_buildQuerySelectSection($_id);
		 $_db->setQuery( $_query);
	  $_sectionfields= $_db->loadColumn();
		*/
		 
		// Transformamos los datos del formulario en variables
		foreach ($_vars as $_var) {
			$_name=$_var->var;
			//$_valid=false;
			$_value='';
			if ($_var->type=='11'){
				$_attach_store[]='imageUpload_'.$_var->id;
				$_attach_store[]='imageUpload_http_'.$_var->id;
				foreach(($_sessioncb->get('imageUpload_'.$_var->id)) as $uptmp):
					$_attach[]=$uptmp;		
				endforeach;	
				$_file_tmp = $_sessioncb->get('imageUpload_http_'.$_var->id);
				$_tmp_value='';
				if($_file_tmp!=null && isset($_file_tmp) && count($_file_tmp)>0){
					foreach ($_file_tmp as $f){
						$_tmp_value.='<a href="'.$f.'" target="_blank">'.$f.'</a><br />';
					}
				}
				eval("\$".$_name."='".$_tmp_value."';");
			}
		}

		/*SHPInit9*/
		if($ishkplugin){
			$arrinput=JFactory::getApplication()->input->post->get('data', array(), 'array');
			foreach($arrinput["item"] as $keycustom=>$valuecustom){				 
				$$keycustom=$valuecustom;
			}
			$idp=JFactory::getApplication()->input->get('idhikaproduct');
			$productClass = hikashop_get('class.product');
			$productData = $productClass->get($idp);
			$config =& hikashop_config();
			$currencyClass = hikashop_get('class.currency');
			$main_currency = $currency_id = (int)$config->get('main_currency',1);
	 		$zone_id = explode(',',$config->get('main_tax_zone',0));
		 	if(count($zone_id)){
		 		$zone_id = array_shift($zone_id);
		 	}else{
		 		$zone_id=0;
		 	}
		 	$ids = array($product->product_id);
		 	$discount_before_tax = (int)$config->get('discount_before_tax',0);
		 	$currencyClass->getPrices($productData,$ids,$currency_id,$main_currency,$zone_id,$discount_before_tax);


		}
		/*SHPEnd9*/

		$_arrData=$this->getDataFormAndMatrix();
		foreach ($_arrData as $_key=>$_value){
			eval("\${$_key}=\$_value;");
		}

		$_vm_price=0;
		$_vm_desc='';

		// UserData
		$this->setUserData($_solution->datasave);

		$_code=$_solution->code;

		/*SHPInit8*/
		// Add Excel init
		$_excel=$this->_getTableObject('#__calcbuilder_excel','idobj='.$_id)->getProperty('data');
		if($_excel):
		require_once(JPATH_COMPONENT_SITE."/views/calcbuilder/helper/PHPExcel.php");
		//$locale = 'De'; //Poner en parametro
		$validLocale = PHPExcel_Settings::setLocale($_excel->locale);
		$inputFileName = JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$_excel->excelfile;
		try {
			if ($_sessioncb->has('PHPExcelObj')&&$_excel->cache==1):
			$objPHPExcel =unserialize($_sessioncb->get('PHPExcelObj'));
			else:
			$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
			if($_excel->cache==1) $_sessioncb->set('PHPExcelObj',serialize($objPHPExcel));
			endif;
		} catch(PHPExcel_Reader_Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}	  catch(Exception $e) {
			$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
		}
		$_excelmappings=$this->_getTableObject('#__calcbuilder_excel_mapping','idexcel='.$_excel->id,null,true)->getProperty('data');
		endif;
		if(($_excel)&&$_excel->excelexec==0):
		$_code=$this->executeExcelContent($_excelmappings,$objPHPExcel).'
      			'.$_code;
		endif;
		// Replace excel inline
		if(($_excel)&&$_excel->excelexec==2):
		$_code=str_replace('//[EXCEL]', $this->executeExcelContent($_excelmappings,$objPHPExcel), $_code);
		endif;
		// Add Excel End
		if(($_excel)&&$_excel->excelexec==1):
		$_code=$_code.'
      			'.$this->executeExcelContent($_excelmappings,$objPHPExcel);
		endif;
		 

		/*SHPEnd8*/
		// Eval solution
		eval($_code);

		/* TEST WRITE EXCEL FILE */
		/*$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
	  //$objWriter->setPreCalculateFormulas(false);
	  $file=JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.'excel'.time().".xls";
	  $objWriter->save($file);
		*/
		// Stats
		$this->setStats($_solution,$_vars);
		$_layoutsolution=$_solution->exitlayout;

		/*SHPInit5*/
		// Excel
		if($_excel&&$_excel->htmloutput==1):
		$objPHPExcel->getSheet($_excel->htmloutputpage)->setShowGridlines(false);
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'HTML');
		$objWriter->setIncludeCharts(true);
		$objWriter->setSheetIndex($_excel->htmloutputpage);
		$_layoutsolution=$objWriter->generateSheetData();
		endif;
		
		//eShop		
		$_layoutsolution=$_layoutsolution.$this->getEShopForm($es_idtemplate,$es_quantity,$es_product_price,$es_product_desc,$es_product_fields);
		
		//Hikashop
		$_layoutsolution=$_layoutsolution.$this->getHikaShopForm($hk_quantity,$hk_product_name,$hk_product_description,$hk_file_name,$hk_file_description,$hk_pricehikaproduct,$hk_productfields,$hk_product_code);

		// VirtueMart
		$idvmactivo=$_sessioncb->get('activevmproduct');
		 
		if($_sessioncb->get('calculatedqty_'.$idvmactivo)!=null){
			$_layoutsolution.='<input type="hidden" name="cb_qtysc" value="'.$_sessioncb->get('calculatedqty_'.$idvmactivo).'"/>';
		}
		if($_sessioncb->get('calculateddesc_'.$idvmactivo)!=null){
			$_layoutsolution.='<input type="hidden" name="cb_descsc" value="'.$_sessioncb->get('calculateddesc_'.$idvmactivo).'"/>';
		}
		if($_sessioncb->get('calculatedprice_'.$idvmactivo)!=null){
			$_layoutsolution.='<input type="hidden" name="cb_pricesc" value="'.$_sessioncb->get('calculatedprice_'.$idvmactivo).'"/>';
		}
		/*SHPEnd5*/

		// Cambiamos por HTML
		$_layoutsolution=htmlspecialchars($_layoutsolution,ENT_QUOTES,'UTF-8');

		// Sustituimos por variables
		// &#35;  #
		$_layoutsolution=preg_replace('/([#]{2})(\w)*([#]{2})/', "'.$$0.'", $_layoutsolution);
		$_layoutsolution=preg_replace('/([#]{2})/', "", $_layoutsolution);
		$_sol='';
		eval("\$_sol='".$_layoutsolution."';");
		// Cambiamos html por characteres
		$_layoutsolution=html_entity_decode($_sol,ENT_QUOTES,'UTF-8');


		// Cambiamos por HTML precalcprint
		$_precalcprint=htmlspecialchars($_solution->precalcprint,ENT_QUOTES,'UTF-8');
		// Sustituimos por variables
		// &#35;  #
		$_precalcprint=preg_replace('/([#]{2})(\w)*([#]{2})/', "'.$$0.'", $_precalcprint);
		$_precalcprint=preg_replace('/([#]{2})/', "", $_precalcprint);
		$_sol='';
		eval("\$_pcp='".$_precalcprint."';");
		// Cambiamos html por characteres
		$_precalcprint=html_entity_decode($_pcp,ENT_QUOTES,'UTF-8');
		$_solution->precalcprint=$_precalcprint;

		$_precalcprintpdf=htmlspecialchars($_solution->precalcprintpdf,ENT_QUOTES,'UTF-8');
		$_precalcprintpdf=preg_replace('/([#]{2})(\w)*([#]{2})/', "'.$$0.'", $_precalcprintpdf);
		$_precalcprintpdf=preg_replace('/([#]{2})/', "", $_precalcprintpdf);
		$_sol='';
		eval("\$_pcppdf='".$_precalcprintpdf."';");
		// Cambiamos html por characteres
		$_precalcprintpdf=html_entity_decode($_pcppdf,ENT_QUOTES,'UTF-8');
		$_solution->precalcprintpdf=$_precalcprintpdf;

		// Cambiamos por HTML poscalcprint
		$_poscalcprint=htmlspecialchars($_solution->poscalcprint,ENT_QUOTES,'UTF-8');
		// Sustituimos por variables
		// &#35;  #
		$_poscalcprint=preg_replace('/([#]{2})(\w)*([#]{2})/', "'.$$0.'", $_poscalcprint);
		$_poscalcprint=preg_replace('/([#]{2})/', "", $_poscalcprint);
		$_sol='';
		eval("\$_pocp='".$_poscalcprint."';");
		// Cambiamos html por characteres
		$_poscalcprint=html_entity_decode($_pocp,ENT_QUOTES,'UTF-8');
		$_solution->poscalcprint=$_poscalcprint;

		$_poscalcprintpdf=htmlspecialchars($_solution->poscalcprintpdf,ENT_QUOTES,'UTF-8');
		$_poscalcprintpdf=preg_replace('/([#]{2})(\w)*([#]{2})/', "'.$$0.'", $_poscalcprintpdf);
		$_poscalcprintpdf=preg_replace('/([#]{2})/', "", $_poscalcprintpdf);
		$_sol='';
		eval("\$_pocppdf='".$_poscalcprintpdf."';");
		// Cambiamos html por characteres
		$_poscalcprintpdf=html_entity_decode($_pocppdf,ENT_QUOTES,'UTF-8');
		$_solution->poscalcprintpdf=$_poscalcprintpdf;

		// Calculamos la solucion
		$_retorno=array();

		$_retorno['code']=$_layoutsolution;
		$_retorno['name']=$_solution->name;
		$_retorno['info']=$_solution->info;
		$_retorno['id']=$_solution->id;
		$_retorno['vars']=$_arrVars;
		$_retorno['solution']=$_solution;

		$_external_content='';
		$_external_content_pdf='';
		if ($_solution->import_bootstrap){
			$_external_content.='<div class="cb_bootstrap"><link href="'.JURI::base().'/modules/mod_calcbuilder/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
      			<link href="'.JURI::base().'/modules/mod_calcbuilder/assets/css/bootstrap-responsive.min.css" rel="stylesheet" type="text/css"/>';
			$_external_content_pdf.='<div class="cb_bootstrap"><link href="'.JURI::base().'/modules/mod_calcbuilder/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
      			<link href="'.JURI::base().'/modules/mod_calcbuilder/assets/css/bootstrap-responsive.min.css" rel="stylesheet" type="text/css"/>';
		}
		if ($this->_type==$this::TYPE_PDF || $this->_type==$this::TYPE_EXCEL):
			$_external_content.=$_retorno['solution']->precalcprintpdf;
		else:
			$_external_content.=$_retorno['solution']->precalcprint;
			$_external_content_pdf.=$_retorno['solution']->precalcprintpdf;
		endif;

		//$_mail_content.=$_retorno['code'];
		$_includeinput=($this->_type==$this::TYPE_EMAIL||($this->_type==$this::TYPE_CALC && $_solution->include_input))?$_solution->include_input:$_solution->include_input_pdf;
		if ($_includeinput){
			$_query = $this->_buildQuerySelectSectionLayout($_id);
			$_db->setQuery( $_query);
			$_sections= $_db->loadObjectList();

			$_arrkeys=array();
			$_arrvals=array();

			foreach ($_sections as $_section){
				$_arrkeys[]='##'.$_section->name.'##';
				//$_arrvals[]=$_section->layout;
				$_fields_temp=explode(',', $_section->fields);
				$_fields_temp=array_map('trim',$_fields_temp);
				$_fields_temp=array_filter($_fields_temp, 'strlen');
				$_numElements=0;
				foreach ($_fields_temp as $field_temp){
					$_query = $this->_buildQueryFieldById($field_temp);
					$_db->setQuery( $_query);
					$_tmpobjField= $_db->loadObject();
					$_tmptmparr=$_tmpobjField->var;
					$_tmpvararr=$$_tmptmparr;
					$_numElements=count($_tmpvararr)>$_numElements?count($_tmpvararr):$_numElements;
				}
					
				$_tmp_secvals=array();
				for($i=0;$i<$_numElements;$i++){
					$sec_keys=array();
					$sec_vals=array();
					foreach ($_fields_temp as $field_temp){
						$_query = $this->_buildQueryFieldById($field_temp);
						$_db->setQuery( $_query);
						$_tmpobjField= $_db->loadObject();
						$_tmptmparr=$_tmpobjField->var;
						$_tmpvararr=$$_tmptmparr;
						$sec_keys[]='##'.$_tmpobjField->var.'##';
						$sec_vals[]=$_tmpvararr[$i];
					}
					$_tmp_secvals[]=str_replace($sec_keys, $sec_vals, $_section->layout);
				}
				$_arrvals[]= implode('', $_tmp_secvals);
			}

			foreach ($_vars as $_var){
				$_tmpkey='##'.$_var->var.'##';
				$_tmptmp=$_var->var;
				$_tmpvar=$$_tmptmp;
				//if (is_array($_tmpvar) || ($_var->type=='2' || $_var->type=='6' || $_var->type=='12')){
				if (!is_array($_tmpvar) && ($_var->type=='2' || $_var->type=='6' || $_var->type=='12'  || $_var->type=='7') &&
						!($_var->sqltext!=null && trim($_var->sqltext)!='')){
					$_tmptmparr=$_var->var.'_name';
					$_tmpvararr=$$_tmptmparr;
					if($_tmpvararr!=null) $_arrvals[]=$_tmpvararr;
				} else if (is_array($_tmpvar)){
					$_tmptmparr=$_var->var.'_name';
					$_tmpvararr=$$_tmptmparr;
					if($_tmpvararr!=null) $_arrvals[]=implode(' ', $_tmpvararr);
				}
				else if($_tmpvar!=null) {
					$_arrvals[]=$_tmpvar;
				}
				if ($_tmpvar!=null){
					$_arrkeys[]=$_tmpkey;
				}
					
			}
				
			$_external_content.=str_replace($_arrkeys, $_arrvals, $_solution->layout);
			$_external_content_pdf.=str_replace($_arrkeys, $_arrvals, $_solution->layout);
		}
		$_includeresult=($this->_type==$this::TYPE_EMAIL||($this->_type==$this::TYPE_CALC && $_solution->include_input))?$_solution->include_result:$_solution->include_result_pdf;
		if ($_includeresult){
			$_external_content.=$_retorno['code'];
		}
		if ($_solution->include_result_pdf){
			$_external_content_pdf.=$_retorno['code'];
		}
		if ($this->_type==$this::TYPE_PDF || $this->_type==$this::TYPE_EXCEL):
			$_external_content.=$_retorno['solution']->poscalcprintpdf;
		else:
			$_external_content.=$_retorno['solution']->poscalcprint;
			$_external_content_pdf.=$_retorno['solution']->poscalcprintpdf;
		endif;

		if ($_solution->import_bootstrap){$_external_content.='</div>';$_external_content_pdf.='</div>';}

		$_retorno['external_content']=$_external_content;
		//2015035 PDF creado a partir del html e insertado como attach
		//20160422 En configuracion
		if ($_solution->emailaddpdf=='1'):
		require_once (JPATH_COMPONENT."/views/calcbuilder/mpdf/mpdf.php");
		if ($_solution->pdf_orientation)
			$mpdf = new mPDF ( '', 'A4-L' );
		else
			$mpdf = new mPDF ( '', 'A4' );
		/* Decuspena
		if ($_solution->pdf_orientation)
			$mpdf = new mPDF ( '', 'A4-L','','',15,15,16,40,9,9);
		else
			$mpdf = new mPDF ( '', 'A4','','',15,15,16,40,9,9);
			*/
		$mpdf->WriteHTML ($_external_content_pdf);
		$filename=rand(1000, 9000)."_cb.pdf";
		$mpdf->Output (JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$filename,'F');
		$_attach[]=JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$filename;
		endif;

		// Mailchimp
		if ($_solution->mc_apply && $_solution->mc_api!=null && $_solution->mc_email!=null && $_solution->mc_list!=null):
		$_mailchimp=new MailChimp($_solution->mc_api);
		$_emailmc_name=$_solution->mc_email_name!=null?${$_solution->mc_email_name}:'';
		$_emailmc_lastname=$_solution->mc_email_lastname!=null?${$_solution->mc_email_lastname}:'';
		$_resultmc=$_mailchimp->call('lists/subscribe', array(
				'id'                => $_solution->mc_list,
				'email'             => array('email'=>${$_solution->mc_email}),
				'merge_vars'        => array('FNAME'=>$_emailmc_name, 'LNAME'=>$_emailmc_lastname),
				'double_optin'      => false,
				'update_existing'   => true,
				'replace_interests' => false,
				'send_welcome'      => false,
		));
		endif;


		/*SHPInit7*/
		// REturn hkplugin
		if($ishkplugin):
			$_retorno['hk_calculatedprice']=$hk_calculatedprice;
			$_retorno['hk_calculatedqty']=$hk_calculatedqty;
			$_retorno['hk_calculatedpriceformat']=$hk_calculatedpriceformat;
			$_retorno['hk_calculatedparams']=json_encode($hk_calculatedparams);
		endif;
		// Excel Pdf
		if($_excel&&$_excel->pdfoutput==1):
			$rendererName = PHPExcel_Settings::PDF_RENDERER_MPDF;
			$rendererLibrary = 'mPDF';
			require_once(JPATH_COMPONENT_SITE."/views/calcbuilder/helper/PHPExcel.php");
			$rendererLibraryPath = JPATH_COMPONENT_SITE."/views/calcbuilder/mpdf/";
			PHPExcel_Settings::setPdfRenderer($rendererName,$rendererLibraryPath);
			$objPHPExcel->getSheet($_excel->pdfoutputpage)->setShowGridlines(false);
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'PDF');
			$objWriter->setSheetIndex($_excel->pdfoutputpage);
			$objWriter->setIncludeCharts(true);
			$filename=rand(1000, 9000)."_cb.pdf";
			$objWriter->save(JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$filename);
			$_retorno['external_content_pdf']=JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$filename;
		elseif($_excel&&$_excel->exceloutput==1):
			$filename=rand(1000, 9000)."_cb.xlsx";
			$objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
			$objWriter->setIncludeCharts(true);
			$objWriter->setPreCalculateFormulas(true);
			$objWriter->save(JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$filename);
			$_retorno['external_content_excel']=JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$filename;
		endif;

		//Hikashop file
		if($_sessioncb->get('cb_hs_outputfile')!=null):
			$mpdf=new mPDF('','A4');
			$mpdf->WriteHTML($_external_content);
			$mpdf->Output($_sessioncb->get('cb_hs_outputfile'),'F');
			$_sessioncb->clear('cb_hs_outputfile');
		endif;
		/*SHPEnd7*/

		// Email
		if ($_solution->sendemailform!=null && $sendEmail){
			$_mail_content=$_retorno['external_content'];
			$_emailarr=explode(';',$_solution->sendemailform);
			$_emailSend=array();
			foreach ($_emailarr as $_email){
				if (strrpos($_email,'$')===false){
					$_emailSend[]=$_email;
				} else {
					eval('$_emailSend[]='.$_email.';');
				}
			}
			$this->getEnvioWrapper($_emailSend,$_mail_content,$_solution->mail_subject,$_attach,$_solution->sendemailcc,$_solution->sendemailbcc);
		}

		// Delete attach
		if ($_attach!=null && count($_attach)>0) {
			//JFile::delete($_attach);
			foreach ($_attach_store as $_attach_files){
				$_sessioncb->clear($_attach_files);
			}
		}
		// Delete files in session
		foreach ($_vars as $_var) {
			if ($_var->type=='11'){
				$_sessioncb->clear('imageUpload_'.$_var->id);
				$_sessioncb->clear('imageUpload_http_'.$_var->id);
			}
		}
		/*SHPInit3*/
		// VM
		if($_solution->vm_product_type!=null){
			$_productsVMStored=$this->getVMProductsSaved($_solution->id);
			foreach ($_productsVMStored as $_prods){
				if ($_solution->vm_product_type=='0'){
					eval('$_nametmp=$vm_desc_'.$_prods->idvmproduct.';');
					$_sessioncb->set('cb_vm_desc_'.$_solution->id.'_'.$_prods->idvmproduct,$_nametmp);
					eval('$_nametmp2=$vm_price_'.$_prods->idvmproduct.';');
					$_sessioncb->set('cb_vm_price_'.$_solution->id.'_'.$_prods->idvmproduct,$_nametmp2);
				}
				$_sessioncb->clear('cb_vm_id_'.$_solution->id.'_'.$_prods->idvmproduct);
				$_sessioncb->set('cb_vm_id_'.$_solution->id.'_'.$_prods->idvmproduct,$_prods->idvmproduct);
				//$_session->set('cb_vm_qty_'.$_solution->id.'_'.$_prods->idvmproduct,$$vm_qty_.$_prods->idvmproduct);
				$_sessioncb->clear('cb_vm_qty_'.$_solution->id.'_'.$_prods->idvmproduct);
				eval('$_nametmp3=$vm_qty_'.$_prods->idvmproduct.';');
				$_sessioncb->set('cb_vm_qty_'.$_solution->id.'_'.$_prods->idvmproduct,$_nametmp3);
			}
		}
		/*SHPEnd3*/
		return $_retorno;
		 
	}

	/*SHPInit4*/
	function getCalcVMPlg($_arrData,$_id){	
		$returnVM=array();
		/*foreach ($_arrData as $_key=>$_value){
			eval("\${$_key}=\$_value;");
		}*/
		$_solution=$this->getCalculator($_id);
		$_code=$_solution->code;
		
		$_db =JFactory::getDBO();
		$_query = $this->_buildQueryMatrix($_id,0);
		$_db->setQuery( $_query);
		$_matrices=$_db->loadObjectList();
		$_arrDataInput=array();
		foreach ($_matrices as $_matrix) {
			$_matTemp=$_matrix->value;
			$_matVar=$_matrix->var;
			$_matVarName=$_matrix->var;
			eval("\$__tmp=".$_matTemp.";");
			$_arrDataInput[$_matVar]=$__tmp;
		}
		foreach ($_arrDataInput as $_key=>$_value){
			eval("\${$_key}=\$_value;");
		}
		
		// Add Excel init
		$_sessioncb = JFactory::getSession();
		$_excel=$this->_getTableObject('#__calcbuilder_excel','idobj='.$_id)->getProperty('data');
		if($_excel):
		require_once(JPATH_COMPONENT_SITE."/views/calcbuilder/helper/PHPExcel.php");
		$inputFileName = JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$_excel->excelfile;
		try {
			if ($_sessioncb->has('PHPExcelObj')&&$_excel->cache==1):
			$objPHPExcel =unserialize($_sessioncb->get('PHPExcelObj'));
			else:
			$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
			if($_excel->cache==1) $_sessioncb->set('PHPExcelObj',serialize($objPHPExcel));
			endif;
		} catch(PHPExcel_Reader_Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}	  catch(Exception $e) {
			$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
		}
		$_excelmappings=$this->_getTableObject('#__calcbuilder_excel_mapping','idexcel='.$_excel->id,null,true)->getProperty('data');
		endif;


		if(($_excel)&&$_excel->excelexec==0):
		$_code=$this->executeExcelContent($_excelmappings,$objPHPExcel).'
	      			'.$_code;
		endif;
		// Replace excel inline
		if(($_excel)&&$_excel->excelexec==2):
		$_code=str_replace('//[EXCEL]', $this->executeExcelContent($_excelmappings,$objPHPExcel), $_code);
		endif;
		// Add Excel End
		if(($_excel)&&$_excel->excelexec==1):
		$_code=$_code.'
	      			'.$this->executeExcelContent($_excelmappings,$objPHPExcel);
		endif;
		
		eval($_code);
		/*
		 $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		 //$objWriter->setPreCalculateFormulas(false);
		 $file=JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.'excel'.time().".xls";
		 $objWriter->save($file);
		*/
		return $returnVM;
	}
	/*SHPEnd4*/
	

	function getCalcinline(){
		$ret=array();
		$allvars=MSHelper::__requestGetVarWrapper('idinline',null);
		$isCalcinline=true;
		if($allvars!=null){
			$_id = MSHelper::__requestGetVarWrapper('id');
			$_solution=$this->getCalculator($_id);
			$_arrData=$this->getDataFormAndMatrix();
			foreach ($_arrData as $_key=>$_value){
				eval("\${$_key}=\$_value;");
			}
			$_code=$_solution->code;


			/*SHPInit1*/
			// Add Excel init
			$_sessioncb = JFactory::getSession();
			$_excel=$this->_getTableObject('#__calcbuilder_excel','idobj='.$_id)->getProperty('data');
			if($_excel):
			require_once(JPATH_COMPONENT_SITE."/views/calcbuilder/helper/PHPExcel.php");
			$inputFileName = JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.$_excel->excelfile;
			try {
				if ($_sessioncb->has('PHPExcelObj')&&$_excel->cache==1):
				$objPHPExcel =unserialize($_sessioncb->get('PHPExcelObj'));
				else:
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				if($_excel->cache==1) $_sessioncb->set('PHPExcelObj',serialize($objPHPExcel));
				endif;
			} catch(PHPExcel_Reader_Exception $e) {
				die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
			}	  catch(Exception $e) {
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
			}
			$_excelmappings=$this->_getTableObject('#__calcbuilder_excel_mapping','idexcel='.$_excel->id,null,true)->getProperty('data');
			endif;
			 

			if(($_excel)&&$_excel->excelexec==0):
			$_code=$this->executeExcelContent($_excelmappings,$objPHPExcel).'
		      			'.$_code;
			endif;
			// Replace excel inline
			if(($_excel)&&$_excel->excelexec==2):
			$_code=str_replace('//[EXCEL]', $this->executeExcelContent($_excelmappings,$objPHPExcel), $_code);
			endif;
			// Add Excel End
			if(($_excel)&&$_excel->excelexec==1):
			$_code=$_code.'
		      			'.$this->executeExcelContent($_excelmappings,$objPHPExcel);
			endif;

			/*SHPEnd1*/
			eval($_code);
			/*
			 $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
			 //$objWriter->setPreCalculateFormulas(false);
			 $file=JPATH_ROOT.DS."media".DS.'com_calcbuilder'.DS.'excel'.time().".xls";
			 $objWriter->save($file);
			*/

			$_db =JFactory::getDBO();
			$vars=json_decode($allvars,true);
			$arrVars=array();
			foreach ($vars as $vartmp){
				$varexpl=explode('_', $vartmp);
				$_query = $this->_buildQueryFieldById($varexpl[1]);
				$_db->setQuery( $_query);
				$var=$_db->loadObject()->var;
				if(${$var}!=null && ${$var}!=''):
				$ret[$vartmp]=${$var};
				else:
				$ret[$vartmp]=$_db->loadObject()->defaulttext;
				endif;
			}
		}
		return json_encode($ret);
	}

	function getDataFormAndMatrix($isSqlinline=false){
		$_id = MSHelper::__requestGetVarWrapper('id');
		$_db =JFactory::getDBO();
		$_solution=$this->getCalculator($_id);
		$_query = $this->_buildQueryFieldsWOOrder($_id,1);
		$_db->setQuery($_query);
		$_vars=$_db->loadObjectList();
		$_arrVars=array();
		$_query = $this->_buildQuerySelectSection($_id);
		$_db->setQuery( $_query);
		$_sectionfields= $_db->loadColumn();
		$_query = $this->_buildQueryMatrix($_id,0);
		$_db->setQuery( $_query);
		$_matrices=$_db->loadObjectList();

		$ret=array();

		// Transformamos los datos del formulario en variables
		foreach ($_vars as $_var) {
			$_name=$_var->var;
			//$_valid=false;
			$_value='';
			if ($_var->type=='11') { continue;
			}elseif ($_var->type=='7' || (in_array($_var->id, $_sectionfields) && !$isSqlinline) ){
				$_value=MSHelper::__requestGetVarWrapper('fld_'.$_var->id, array(), '', 'array');
				$__tmp=array();
				if ($_var->type=='2' || $_var->type=='6' || $_var->type=='7' || $_var->type=='12'){
					$ret[$_name.'_name']=array();
					$__tmp_name=array();
					foreach ($_value as $_valueInt){
						if($_valueInt!=''){
							if ($_var->sqltext!=null && trim($_var->sqltext)!=''){
								eval("\$__tmp[]='".$_valueInt."';");
							} else {
								$_mv=$this->getMultivalue($_valueInt);
								if (isset($_mv)){
									eval("\$__tmp[]='".$_mv->value."';");
									eval("\$__tmp_name[]='".$_mv->name."';");
								} else {
									eval("\$__tmp[]='';");
									eval("\$__tmp_name[]='';");
								}
							}
						} else {
							eval("\$__tmp[]='';");
							eval("\$__tmp_name[]='';");
						}
					}
					$ret[$_name]=$__tmp;
					$ret[$_name.'_name']=$__tmp_name;
				} else {
					foreach ($_value as $_valueInt){
						//$_valueInt=str_replace("'", "\'", $_valueInt);
						if ($_var->type=='0'){
							$_valueInt=str_replace($_solution->thousand_number_format, "", $_valueInt);
							$_valueInt=str_replace($_solution->decimal_number_format, ".", $_valueInt);
						}
						eval("\$__tmp[]='".$_valueInt."';");
						$ret[$_name]=$__tmp;
					}
				}
				//$_valid=count($_value)>0;
			} elseif ($_var->type=='2' || $_var->type=='6' || $_var->type=='12'){
				$_value=MSHelper::__requestGetVarWrapper('fld_'.$_var->id);
				
				if (in_array($_var->id, $_sectionfields) && $isSqlinline){ //Beta
					//$value=$value[0];
					$_value=MSHelper::__requestGetVarWrapper('fld_'.$_var->id, array(), '', 'array');
					$_value=$_value[0];
				}
				if($_value!=''){
					$_value=trim($_value);
					if ($_var->sqltext!=null && trim($_var->sqltext)!=''){
						$ret[$_name]=$_value;
					} else {
						$_mv=$this->getMultivalue($_value);
						if (isset ($_mv)){
							$ret[$_name]=$_mv->value;
							$ret[$_name.'_name']=$_mv->name;
						}
					}
				} else {
				}
				/*if (is_array($_value)){ //TODO
					
					
				} else if($_value!=''){
					$_value=trim($_value);
					if ($_var->sqltext!=null && trim($_var->sqltext)!=''){
						$ret[$_name]=$_value;
					} else {
						$_mv=$this->getMultivalue($_value);
						if (isset ($_mv)){
							$ret[$_name]=$_mv->value;
							$ret[$_name.'_name']=$_mv->name;
						}
					}
				} else {
				}*/
			} else {
				$_value=MSHelper::__requestGetVarWrapper('fld_'.$_var->id);
				if (is_array($_value)) continue;
				$_value=trim($_value);
				//$_value=str_replace("'", "\'", $_value);
				if ($_var->type=='0'){
					$_value=str_replace($_solution->thousand_number_format, "", $_value);
					$_value=str_replace($_solution->decimal_number_format, ".", $_value);
				}
				$ret[$_name]=$_value;
			}
		}

		// Recorremos las matrices y las evaluamos
		foreach ($_matrices as $_matrix) {
			$_matTemp=$_matrix->value;
			$_matVar=$_matrix->var;
			$_matVarName=$_matrix->var;
			eval("\$__tmp=".$_matTemp.";");
			$ret[$_matVar]=$__tmp;
		}
		//var_dump($ret);
		return $ret;
	}

	function getEnvio(){
		$this->_type=$this::TYPE_CALC;
		$calc=$this->getCalculoWrapper(false);
		$mail_content="";
		//$arrValues=$calc['code'];
		/*$mail_content=$calc['solution']->precalcprint;
		$mail_content.=$calc['code'];
		$mail_content.=$calc['solution']->poscalcprint;*/
		$mail_content=$calc['external_content'];
		return $this->getEnvioWrapper(trim(MSHelper::__requestGetVarWrapper('email')),$mail_content,$calc['solution']->mail_subject);
	}

	function getEnvioWrapper($email,$mail_content,$subject,$attach=null,$cc=null,$bcc=null){
		// Enviamos email
		$config =JFactory::getConfig();
		$jversion = new JVersion ();
		$error=false;
		$normal=true;
		$attach=array_filter($attach);
		if ($normal):
			try {			
				$mailer =JFactory::getMailer();
				$mailer->setSubject($subject);			
				if (version_compare ( $jversion->getShortVersion (), 3, 'lt' )) :
					$sender = array(
				  	$config->getValue( 'config.mailfrom' ),
				  	$config->getValue( 'config.fromname' ) );
				else:
					$sender = array(
				  	$config->get( 'mailfrom' ),
				  	$config->get( 'fromname' ) );
				endif;
				$mailer->setSender($sender);
				$mailer->addRecipient($email);
				if ($cc!=null):
					$ccitems=explode(';',$cc);
					foreach ($ccitems as $ccitem):
						$mailer->addCC($ccitem);
					endforeach;
				endif;
				if ($bcc!=null):
					$bccitems=explode(';',$bcc);
					foreach ($bccitems as $bccitem):
						$mailer->addBCC($bccitem);
					endforeach;
				endif;
				$mailer->isHTML(true);
				if ($attach!=null && count($attach)>0){
					$mailer->addAttachment($attach);					
				}
				// CSS File
				//$stylesheet = MSHelper::__requestGetVarWrapper('style')!=null?file_get_contents(JURI::base().'modules/mod_calcbuilder/assets/css/'.MSHelper::__requestGetVarWrapper('style')):'';
				//$stylesheet = file_get_contents(JURI::base().'modules/mod_calcbuilder/assets/css/'.MSHelper::__requestGetVarWrapper('style'));
				//$mail_content='<html><style>'.$stylesheet.'</style><body>'.$mail_content.'</body></html>';
				$mail_content='<html><body>'.$mail_content.'</body></html>';
				$mailer->setBody($mail_content);
				$send = $mailer->Send();
				return $send;
			} catch (Exception $e) {
				$error=true;
			}
		endif;
		if (!$normal || $error):
			if (version_compare ( $jversion->getShortVersion (), 3, 'lt' )) :
				$cabeceras = "From: ".$config->getValue( 'config.mailfrom' )."\r\nContent-type: text/html\r\n";
			else:
				$cabeceras = "From: ".$config->get( 'mailfrom' )."\r\nContent-type: text/html\r\n";
			endif;
			if ($cc!=null):
				$ccitems=explode(';',$cc);
				foreach ($ccitems as $ccitem):
					$cabeceras .= "Cc: ".$ccitem."\r\n";
				endforeach;
			endif;
			if ($bcc!=null):
				$bccitems=explode(';',$bcc);
				foreach ($bccitems as $bccitem):
					$cabeceras .= "Bcc: ".$bccitem."\r\n";
				endforeach;
			endif;
			
			$random_hash = md5(date('r', time()));
			//$attachment = chunk_split(base64_encode(file_get_contents('attachment.zip')));
			//define the body of the message.
			$newmessage='
			--PHP-mixed-'.$random_hash.' 
			Content-Type: multipart/alternative; boundary="PHP-alt-'.$random_hash.'"
			
			--PHP-alt-'.$random_hash.' 
			Content-Type: text/plain; charset="utf-8"
			Content-Transfer-Encoding: 7bit
			
			'.$mail_content.'
			
			--PHP-alt-'.$random_hash.'
			Content-Type: text/html; charset="utf-8"
			Content-Transfer-Encoding: 7bit
			
			'.$mail_content.'
			
			--PHP-alt-'.$random_hash.'--';
			
			if ($attach!=null && count($attach)>0):
				foreach ($attach as $attachItem):
					$attachContent=chunk_split(base64_encode(file_get_contents($attachItem)));
					$newmessage.='--PHP-mixed-'.$random_hash.' 
						Content-Type: application/zip; name="attachment.zip" 
						Content-Transfer-Encoding: base64 
						Content-Disposition: attachment 
						
						'.$attachContent.'
								
						--PHP-mixed-'.$random_hash.'--';
				endforeach;
			endif;
			//copy current buffer contents into $message variable and delete current output buffer
			//$message = ob_get_clean();
			//send the email
			$mail_sent = @mail( $to, $subject, $newmessage, $headers );
			try {
				mail($email[0],$config->get( 'config.sitename' ),$mail_content,$cabeceras);
			} catch (Exception $e) {
				return false;
			}
			//return $e->getMessage();			
		endif;		
		return true;
	}

	function getCalcSqlinline(){
		$db=JFactory::getDbo();
		$allData=$this->getDataFormAndMatrix(true);
		$idField=MSHelper::__requestGetVarWrapper('idfrom');
		$field_obj=$this->_getTableObject('#__calcbuilder_field','id='.$db->quote($idField))->getProperty('data');
		$sqlQuery=$field_obj->combodependantsql;
		foreach ($allData as $k => $v) :
		$allData['##'.$k.'##'] =$db->quote($v);
		//$allData['##'.$k.'##'] =$v;
		unset($allData[$k]);
		endforeach;
		//var_dump($allData);
		$sqlQueryParsed=str_replace(array_keys($allData), array_values($allData),$sqlQuery);
		//$sqlQueryParsed=preg_replace('/([#]{2})(\w)*([#]{2})/', $db->quote(${1}), $sqlQueryParsed);
		$sqlQueryParsed=preg_replace('/([#]{2})/', '', $sqlQueryParsed);
		//echo $sqlQueryParsed;
		$db->setQuery($sqlQueryParsed);
		$resultSqlQuery=$db->loadRowList();
		return $resultSqlQuery;
	}
	 

	function upload(){
		$_id=MSHelper::__requestGetVarWrapper('idcalc');
		$_db =JFactory::getDBO();
		$_query = $this->_buildQuerySelect($_id);
		$_db->setQuery( $_query);
		$calc=$_db->loadObject();
		//this is the name of the field in the html form, filedata is the default name for swfupload
		//so we will leave it as that
		$fieldName = 'file';

		//any errors the server registered on uploading
		$fileError = $_FILES[$fieldName]['error'];
		if ($fileError > 0){
			switch ($fileError)
			{
				case 1:
					//echo JText::_( 'FILE TO LARGE THAN PHP INI ALLOWS' );
					JError::raiseError(500,JText::_('FILE TO LARGE THAN PHP INI ALLOWS'));
					return ;

				case 2:
					//echo JText::_( 'FILE TO LARGE THAN HTML FORM ALLOWS' );
					JError::raiseError(500,JText::_('FILE TO LARGE THAN HTML FORM ALLOWS'));
					return ;
						
				case 3:
					//echo JText::_( 'ERROR PARTIAL UPLOAD' );
					JError::raiseError(500,JText::_('ERROR PARTIAL UPLOAD'));
					return ;
						
				case 4:
					//echo JText::_( 'ERROR NO FILE' );
					JError::raiseError(500,JText::_('ERROR NO FILE'));
					return ;
			}
		}
			
		if ($calc->up_filesize!=null && $calc->up_filesize!=''){
			//check for filesize
			$fileSize = $_FILES[$fieldName]['size'];
			if($fileSize > ($calc->up_filesize*1024*1024))
			{
				//echo JText::_( 'FILE BIGGER THAN 2MB' );
				JError::raiseError(500,JText::_('FILE BIGGER THAN 2MB'));
				return ;
			}
		}
		//check the file extension is ok
		$fileName = $_FILES[$fieldName]['name'];
		$uploadedFileNameParts = explode('.',$fileName);
		$uploadedFileExtension = array_pop($uploadedFileNameParts);


		if ($calc->up_extensions!=null && $calc->up_extensions!=''){
				
			//$validFileExts = explode(',', 'jpeg,jpg,png,gif');
			$validFileExts = explode(',', $calc->up_extensions);

			//assume the extension is false until we know its ok
			$extOk = false;

			//go through every ok extension, if the ok extension matches the file extension (case insensitive)
			//then the file extension is ok
			foreach($validFileExts as $key => $value)
			{
				if( preg_match("/$value/i", $uploadedFileExtension ) )
				{
					$extOk = true;
				}
			}

			if ($extOk == false)
			{
				//echo JText::_( 'INVALID EXTENSION' );
				JError::raiseError(500,JText::_('INVALID EXTENSION'));
				return ;
			}
		}
			
		//the name of the file in PHP's temp directory that we are going to move to our folder
		$fileTemp = $_FILES[$fieldName]['tmp_name'];
			
		//for security purposes, we will also do a getimagesize on the temp file (before we have moved it
		//to the folder) to check the MIME type of the file, and whether it has a width and height
		$imageinfo = getimagesize($fileTemp);

		if ($calc->up_mimetypes!=null && $calc->up_mimetypes!=''){
			//we are going to define what file extensions/MIMEs are ok, and only let these ones in (whitelisting), rather than try to scan for bad
			//types, where we might miss one (whitelisting is always better than blacklisting)
			//$okMIMETypes = 'image/jpeg,image/pjpeg,image/png,image/x-png,image/gif';
			$okMIMETypes = $calc->up_mimetypes;
			$validFileTypes = explode(",", $okMIMETypes);

			//if the temp file does not have a width or a height, or it has a non ok MIME, return
			if( !is_int($imageinfo[0]) || !is_int($imageinfo[1]) ||  !in_array($imageinfo['mime'], $validFileTypes) )
			{
				//echo JText::_( 'INVALID FILETYPE' );
				JError::raiseError(500,JText::_('INVALID FILETYPE'));
				return;
			}
		}
			
		//lose any special characters in the filename
		//seed
		//$fileName = preg_replace("/[^A-Za-z0-9]/i", "-", $fileName).'.'.$uploadedFileExtension;
		switch ($calc->up_prefix){
			case '0':
				$fileName = preg_replace("/[^A-Za-z0-9]/i", "-", $fileName).'_'.time().'.'.$uploadedFileExtension;
				break;
			case '1':
				$user=JFactory::getUser();
				$fileName = preg_replace("/[^A-Za-z0-9]/i", "-", $fileName).'_'.$user->id.'.'.$uploadedFileExtension;
				break;
			case '2':
				$fileName = preg_replace("/[^A-Za-z0-9]/i", "-", $fileName).'_'.$calc->id.'.'.$uploadedFileExtension;
				break;
			case '3':
				$user=JFactory::getUser();
				$fileName = preg_replace("/[^A-Za-z0-9]/i", "-", $fileName).'_'.$user->id.'_'.time().'.'.$uploadedFileExtension;
				break;
			case '4':
				$user=JFactory::getUser();
				$fileName = preg_replace("/[^A-Za-z0-9]/i", "-", $fileName).'_'.$user->id.'_'.time().'_'.$calc->id.'.'.$uploadedFileExtension;
				break;
			default:
				$fileName = preg_replace("/[^A-Za-z0-9]/i", "-", $fileName).'.'.$uploadedFileExtension;
				break;

		}
		// timestamp as seed
		//$fileName = preg_replace("/[^A-Za-z0-9]/i", "-", $fileName).'_'.time().'.'.$uploadedFileExtension;
			
		//always use constants when making file paths, to avoid the possibilty of remote file inclusion
		$user_folder='';
		$user_http_folder='';
		if($calc->up_folder) {
			$user_folder=$calc->up_folder.DS;
			$user_http_folder=str_replace(DS,'/',$user_folder);
		}
		$uploadPath = JPATH_SITE.DS.'images'.DS.'stories'.DS.$user_folder.$fileName;
		$uploadPath_http = JURI::base().'images/stories/'.$user_http_folder.$fileName;

		$session = JFactory::getSession();
		$paths_in_session=$session->get('imageUpload_'.MSHelper::__requestGetVarWrapper('id'));
		if (!isset($paths_in_session)) $paths_in_session=array();
		$paths_in_session[]=$uploadPath;
		$session->set('imageUpload_'.MSHelper::__requestGetVarWrapper('id'),$paths_in_session);

		$paths_in_session=$session->get('imageUpload_http_'.MSHelper::__requestGetVarWrapper('id'));
		if (!isset($paths_in_session)) $paths_in_session=array();
		$paths_in_session[]=$uploadPath_http;
		$session->set('imageUpload_http_'.MSHelper::__requestGetVarWrapper('id'),$paths_in_session);
			
		//var_dump($paths_in_session);

		if(!JFile::upload($fileTemp, $uploadPath)) {
			//echo JText::_( 'ERROR MOVING FILE' );
			JError::raiseError(500,JText::_('ERROR MOVING FILE').' file:'.$fileTemp.' | dest:'.$uploadPath);
			return;
		} else {
			// success, exit with code 0 for Mac users, otherwise they receive an IO Error
			exit(0);
		}

	}


	function _buildQuerySelectVMProducts($id){
		$db =JFactory::getDBO();
		if (!is_numeric($id)) JError::raiseError(500,JText::_('INTERNAL SERVER ERROR'));
		$query = "select * from #__calcbuilder_vm_products where idobj=".$id;
		return $query;
	}

	function getVMProductsSaved($id){
		if ($id=='') return null;
		$db =JFactory::getDBO();
		$query = $this->_buildQuerySelectVMProducts($id);
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	/*SHPInit2*/

	function getVmproduct(){
		$id=JRequest::getVar('id');
		$calc=$this->getCalculator($id);
		if (!class_exists( 'VmConfig' )) include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'config.php');
		if (!class_exists( 'VmConfig' )) return false;
		VmConfig::loadConfig();
		$vmversion=$this->getVMversion();
		$ret=array();
		if($calc->vm_product_type!=null){
			$session =  JFactory::getSession();
			// VM initialize
			//$productModel = VmModel::getModel('Product');
			$productModel = new VirtueMartModelVMCB();
			$productsVMStored=$this->getVMProductsSaved($calc->id);
			foreach ($productsVMStored as $prods){
				$prod_tmp=array();
				// Values
				$cb_prod_id=$session->get('cb_vm_id_'.$calc->id.'_'.$prods->idvmproduct);
				$cb_prod_qty=$session->get('cb_vm_qty_'.$calc->id.'_'.$prods->idvmproduct);
				if($calc->vm_product_type=='0'){
					// Values
					$cb_prod_desc=$session->get('cb_vm_desc_'.$calc->id.'_'.$prods->idvmproduct);
					$cb_prod_price=$session->get('cb_vm_price_'.$calc->id.'_'.$prods->idvmproduct);
					// create new product
					$product = $productModel->getProduct($cb_prod_id, FALSE, TRUE, FALSE);

					$product->virtuemart_product_id = $product->virtuemart_product_price_id = 0;
					//$product->slug = $product->slug . '-' . $cb_prod_id;
					//$product->slug = $cb_prod_id;
					$product->slug = $product->slug . '-' .time();
						
					$product->save_customfields = 1;

					/* Prices */
						
					// version 2.0.8
					$product->product_price=$cb_prod_price;
					$product->product_override_price=$cb_prod_price;
					//$product->product_name=$product->product_name.'  '.$cb_prod_desc;
						
					// Version 2.0.18
					$product_price=array();
					$product_price[]=$cb_prod_price;
						
					$product_override_price=array();
					$product_override_price[]=$cb_prod_price;
						
					$mprices=array();
					$mprices['product_price']=$product_price;
					$mprices['product_override_price']=$product_override_price;
					$mprices['virtuemart_product_price_id']=0;
						
					$product->mprices=$mprices;
						
					/* End prices */
						
					$product->product_name=$cb_prod_desc;
					$product->product_desc=$cb_prod_desc;
					//$productModel->store ($product);
					// Check VM version
					if (version_compare($vmversion, '2.6.10', '<')){// version <2.6.10
						$productModel->CBstore2($product);
					}
					else{// version 2.6.10-3.0.10
						if(version_compare($vmversion, '3.0.10', '<'))
							$productModel->CBstore_o($product,$vmversion);
						else
							$productModel->CBstore($product,$vmversion);
					}
						
					$prod_tmp['id']=$productModel->_id;
				} else {
					// use existing one
					$prod_tmp['id']=$cb_prod_id;
				}
				$prod_tmp['qty']=$cb_prod_qty;
				$ret[]=$prod_tmp;
			}
		}
		return $ret;

	}

	private function getVMversion(){
		$ret=0;
		$db = JFactory::getDbo ();
		$query = $db->getQuery ( true );
		$query->select ( 'extension_id, name,manifest_cache' );
		$query->from ( '#__extensions' );
		$query->where ( 'name=' . $db->quote ('virtuemart').' and type='.$db->quote('component'));
		$db->setQuery ($query);
		$version=$db->loadObject();
		if ($version):
		$manifest=json_decode($version->manifest_cache);
		$ret=$manifest->version;
		endif;
		return $ret;
	}

	function setProductHikashop($product_name,$product_description,$file_name,$file_description,$pricehikaproduct,$product_fields=null,$product_code=null){
		$seed=rand(1000,999999);
		if ($product_code==null) $product_code='';
		$product_code=$product_code.'_'.$seed;
		$db =JFactory::getDBO();
		$query="insert into #__hikashop_product(product_name,
				product_description,product_code,product_type,product_url,
				product_keywords,product_average_score,product_published";
		if($product_fields!=null && count($product_fields)>0):
		$query.=','.implode(',',array_keys($product_fields));
		endif;
		$query.=")
				values('".$product_name."','".$product_description."','".$product_code."','main','','',0,1";
		if($product_fields!=null && count($product_fields)>0):
		foreach ($product_fields as $field_value):
		$query.=','.$db->quote($field_value);
		endforeach;
		endif;
		$query.="	)";
		$db->setQuery($query);
		$db->query();
		$query="select max(product_id) from #__hikashop_product";
		$db->setQuery($query);
		$idhikaproduct=$db->loadResult();
		$query="insert into  #__hikashop_product_category (category_id,product_id,ordering) values (2,".$idhikaproduct.",1)";
		$db->setQuery($query);
		$db->query();
		$query="insert into #__hikashop_price (price_currency_id,price_product_id,price_value)
				values((SELECT config_value FROM #__hikashop_config where config_namekey='main_currency'),".$idhikaproduct.",".$pricehikaproduct.")";
		$db->setQuery($query);
		$db->query();
		if($file_name!=null&&$file_name!=""){
			$filename=$idhikaproduct."_".$seed."_report.pdf";
			$query="insert into #__hikashop_file (file_name,file_description,file_path,file_type,file_ref_id,file_free_download,file_ordering,file_limit)
    				values('".$file_name."','".$file_description."','".$filename."','file',".$idhikaproduct.",0,0,-1)";
			$db->setQuery($query);
			$db->query();
			$session =JFactory::getSession();
			$session->set('cb_hs_outputfile', JPATH_SITE.DS.'media/com_hikashop/upload/safe/'.$filename);
		}
		return $idhikaproduct;
	}
	
	
	 function setProducteShop($es_idtemplate,$es_product_price,$es_product_desc,$es_product_fields){	 
		  require_once JPATH_ROOT.'/administrator/components/com_eshop/libraries/defines.php';
		  require_once JPATH_ROOT.'/administrator/components/com_eshop/libraries/inflector.php';
		  require_once JPATH_ROOT.'/administrator/components/com_eshop/libraries/autoload.php';
		  require_once JPATH_ADMINISTRATOR . '/components/com_eshop/libraries/rad/bootstrap.php';
		  include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_eshop'.DS.'models'.DS.'product.php');
		  $productModel = new EShopModelProduct(array());
		  $newid=$productModel->copy($es_idtemplate);	

		  $db =JFactory::getDBO();
		  $fieldnames="";
		  
		  foreach($es_product_fields as $name=>$value){
		  $fieldnames.=",".$name."='".$value."'";		  
		  
		  }
		  $query="update #__eshop_products  set product_price=".$es_product_price.$fieldnames." where id=".$newid;
		  $db->setQuery($query);
		  $db->query();
		  
		  
		  $fielddesc="";
		  
		  foreach($es_product_desc as $name=>$value){
		  $fielddesc.=",".$name."='".$value."'";		  
		  
		  }
		  $query="update #__eshop_productdetails set product_id=".$newid.$fielddesc." where product_id=".$newid;
		  $db->setQuery($query);
		  $db->query();
		  
		  
		  
		  return $newid;	 
	 }
	
	

	function getHikaShopForm($hk_quantity,$hk_product_name,$hk_product_description,$hk_file_name,$hk_file_description,$hk_pricehikaproduct,$product_fields,$hk_product_code){
		$_linkhtml='';
		if($hk_quantity!=null && $hk_quantity!='0'){
			if(is_null($hk_pricehikaproduct)) $hk_pricehikaproduct=0;
			$_idhikaproduct=$this->setProductHikashop($hk_product_name,$hk_product_description,$hk_file_name,$hk_file_description,$hk_pricehikaproduct,$product_fields,$hk_product_code);
			$_linkhtml.="<form id='form_hika' action='".JURI::Base()."index.php'>";
			$_linkhtml.="<input type='hidden' name='option' value='com_hikashop'/>";
			$_linkhtml.="<input type='hidden' name='ctrl' value='product'/>";
			$_linkhtml.="<input type='hidden' name='task' value='updatecart'/>";
			$_linkhtml.="<input type='hidden' name='quantity' value='".$hk_quantity."'/>";
			$_linkhtml.="<input type='hidden' name='checkout' value='1'/>";
			$_linkhtml.="<input type='hidden' name='product_id' value='".$_idhikaproduct."'/>";
			$_linkhtml.="</form>";
		}
		return $_linkhtml;
	}
	
	
	function getEShopForm($es_idtemplate,$es_quantity,$es_product_price,$es_product_desc,$es_product_fields){
	
	$_linkhtml='';
		if($es_quantity!=null && $es_quantity!='0'){
			if(is_null($es_product_price)) $es_product_price=0;
			//$_idesproduct=$this->setProducteShop($es_idtemplate,$es_quantity,$es_product_price,$es_product_fields);
			//TODO
			$_idesproduct=$es_idtemplate;
			
			$_idesproduct=$this->setProducteShop($es_idtemplate,$es_product_price,$es_product_desc,$es_product_fields);
					
			$_linkhtml.="<form id='form_eshop' action='".JURI::Base()."'>";
			//$_linkhtml.="<input type='hidden' name='option' value='com_eshop'/>";
			//$_linkhtml.="<input type='hidden' name='ctrl' value='product'/>";
			//$_linkhtml.="<input type='hidden' name='task' value='cart.add'/>";
			$_linkhtml.="<input type='hidden' name='quantity' value='".$es_quantity."'/>";
			$_linkhtml.="<input type='hidden' name='checkout' value='1'/>";
			$_linkhtml.="<input type='hidden' name='product_id' value='".$_idesproduct."'/>";
			$_linkhtml.="</form>";
		}
		return $_linkhtml;
	
	
	}

	private function executeExcelContent($mapping,$objPHPExcel){
		$ret=array();
		foreach ($mapping as $map):
		if($map->type==0):
		$ret[]='$objPHPExcel->getSheet("'.$map->sheet.'")->setCellValue("'.$map->cell.'" , $'.$map->phpvar.');';
		endif;
		endforeach;
		$ret[]='PHPExcel_Calculation::getInstance($objPHPExcel)->clearCalculationCache();';
		foreach ($mapping as $map):
		if($map->type==1):
		$ret[]='$'.$map->phpvar.'=$objPHPExcel->getSheet("'.$map->sheet.'")->getCell("'.$map->cell.'")->getFormattedValue();';
		endif;
		endforeach;
		return implode('', $ret);
	}



	public function getHKPlugin(){
		require_once(JPATH_ADMINISTRATOR."/components/com_hikashop/helpers/helper.php");
		$ret=array();
		$_retorno=$this->getCalculoWrapper(false, true);
		$idproduct=MSHelper::__requestGetVarWrapper('idhikaproduct');
		if(isset($_retorno['hk_calculatedprice'])||isset($_retorno['hk_calculatedqty'])):
		if(!isset($_retorno['hk_calculatedprice'])) $_retorno['hk_calculatedprice']="";
		if(!isset($_retorno['hk_calculatedqty'])) $_retorno['hk_calculatedqty']="";
		if(!isset($_retorno['hk_calculatedpriceformat'])) $_retorno['hk_calculatedpriceformat']=$_retorno['hk_calculatedprice'];
		if(!isset($_retorno['hk_calculatedparams'])) $_retorno['hk_calculatedparams']="";
		$productClass=hikashop_get('class.product');
		$product=$productClass->get($idproduct);
		$seed=md5($_retorno['hk_calculatedprice'].''.$product->product_created);
		$ret['params']=$_retorno['hk_calculatedparams'];
		$ret['price']=$_retorno['hk_calculatedprice'];
		$ret['priceformat']=$_retorno['hk_calculatedpriceformat'];
		$ret['qty']=$_retorno['hk_calculatedqty'];
		$ret['control']=$seed;		
		endif;
		return $ret;
	}

	/*SHPEnd2*/

}


?>