<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */
 
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die(); 

jimport( 'joomla.application.component.model' );
if (!class_exists( 'VmConfig' )){ 
	@include (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'helpers'.DS.'config.php');
}

if (!class_exists( 'VirtueMartModelProduct')){
	@include (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'models'.DS.'product.php' );
}

if (class_exists( 'VmConfig' )){
	VmConfig::loadConfig();
	class VirtueMartModelVMCB extends VirtueMartModelProduct
	{
		function __construct () {
			parent::__construct();
		}
		
		public function CBStore_o($product,$vmversion){
			if ($product) {
				$data = (array)$product;
			}
			
			$isChild = FALSE;
			if(!empty($data['isChild'])) $isChild = $data['isChild'];
			
			if (isset($data['intnotes'])) {
				$data['intnotes'] = trim ($data['intnotes']);
			}
			// Setup some place holders
			$product_data = $this->getTable ('products');
			
			if(!empty($data['virtuemart_product_id'])){
				$product_data -> load($data['virtuemart_product_id']);
			}
			//Set the decimals like product packaging
			//$decimals = array('product_length','product_width','product_height','product_weight','product_packaging');
			foreach($this->decimals as $decimal){
				if (array_key_exists ($decimal, $data)) {
					if(!empty($data[$decimal])){
						$data[$decimal] = str_replace(',','.',$data[$decimal]);
					} else {
						$data[$decimal] = null;
						$product_data->$decimal = null;
						//vmdebug('Store product, set $decimal '.$decimal.' = null');
					}
				}
			}
			
			
			//with the true, we do preloading and preserve so old values note by Max Milbers
			//	$product_data->bindChecknStore ($data, $isChild);
			
			//We prevent with this line, that someone is storing a product as its own parent
			if(!empty($product_data->product_parent_id) and $product_data->product_parent_id == $data['virtuemart_product_id']){
				$product_data->product_parent_id = 0;
			}
			
			$stored = $product_data->bindChecknStore ($data, false);
			
			$errors = $product_data->getErrors ();
			
			
			
			
			
			if(!$stored or count($errors)>0){
				foreach ($errors as $error) {
					vmError ('Product store '.$error);
				}
				if(!$stored){
					vmError('You are not an administrator or the correct vendor, storing of product cancelled');
				}
				return FALSE;
			}
			
			
			$this->_id = $data['virtuemart_product_id'] = (int)$product_data->virtuemart_product_id;
			
			if (empty($this->_id)) {
				vmError('Product not stored, no id');
				return FALSE;
			}
			
			//We may need to change this, the reason it is not in the other list of commands for parents
			if (!$isChild) {
				if (!empty($data['save_customfields'])) {
					if (!class_exists ('VirtueMartModelCustomfields')) {
						require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'customfields.php');
					}
					if (version_compare($vmversion, '3.0.0', '<')):
						VirtueMartModelCustomfields::storeProductCustomfields ('product', $data, $product_data->virtuemart_product_id);
					else:
						$modelCustomfields = VmModel::getModel ('Customfields');
						$modelCustomfields->storeProductCustomfields ('product', $data, $product_data->virtuemart_product_id);
					endif;	
				}
			}
			
			// Get old IDS
			if (version_compare($vmversion, '3.0.0', '<')):
				$old_price_ids = $this->loadProductPrices($this->_id,0,0,false);
			else:
				$old_price_ids = $this->loadProductPrices($this->_id,array(),false);
			endif;
			//vmdebug('$old_price_ids ',$old_price_ids);
			if (isset($data['mprices']['product_price']) and count($data['mprices']['product_price']) > 0){
			
				foreach($data['mprices']['product_price'] as $k => $product_price){
			
					$pricesToStore = array();
					$pricesToStore['virtuemart_product_id'] = $this->_id;
					$pricesToStore['virtuemart_product_price_id'] = (int)$data['mprices']['virtuemart_product_price_id'][$k];
			
					if (!$isChild){
						//$pricesToStore['basePrice'] = $data['mprices']['basePrice'][$k];
						
						
						$pricesToStore['product_override_price'] = $data['mprices']['product_override_price'][$k];
						$pricesToStore['override'] = (int)$data['mprices']['override'][$k];
						$pricesToStore['virtuemart_shoppergroup_id'] = (int)$data['mprices']['virtuemart_shoppergroup_id'][$k];
						$pricesToStore['product_tax_id'] = (int)$data['mprices']['product_tax_id'][$k];
						$pricesToStore['product_discount_id'] = (int)$data['mprices']['product_discount_id'][$k];
						$pricesToStore['product_currency'] = (int)$data['mprices']['product_currency'][$k];
						$pricesToStore['product_price_publish_up'] = $data['mprices']['product_price_publish_up'][$k];
						$pricesToStore['product_price_publish_down'] = $data['mprices']['product_price_publish_down'][$k];
						$pricesToStore['price_quantity_start'] = (int)$data['mprices']['price_quantity_start'][$k];
						$pricesToStore['price_quantity_end'] = (int)$data['mprices']['price_quantity_end'][$k];
					}
			
					if (!$isChild and isset($data['mprices']['use_desired_price'][$k]) and $data['mprices']['use_desired_price'][$k] == "1") {
						if (!class_exists ('calculationHelper')) {
							require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'calculationh.php');
						}
						$calculator = calculationHelper::getInstance ();
						$pricesToStore['salesPrice'] = $data['mprices']['salesPrice'][$k];
						$pricesToStore['product_price'] = $data['mprices']['product_price'][$k] = $calculator->calculateCostprice ($this->_id, $pricesToStore);
						unset($data['mprices']['use_desired_price'][$k]);
					} else {
						if(isset($data['mprices']['product_price'][$k]) ){
							$pricesToStore['product_price'] = $data['mprices']['product_price'][$k];
						}
			
					}
			
					if (version_compare($vmversion, '3.0.0', '<')):
						if ($isChild): 
							$childPrices = $this->loadProductPrices($this->_id,0,0,false);
						endif;
					else:
						if ($isChild) $childPrices = $this->loadProductPrices($this->_id,array(),false);
					endif;
			
					if ((isset($pricesToStore['product_price']) and $pricesToStore['product_price']!='') || (isset($childPrices) and count($childPrices)>1)) {
			
						if ($isChild) {
							//$childPrices = $this->loadProductPrices($pricesToStore['virtuemart_product_price_id'],0,0,false);
			
							if(is_array($old_price_ids) and count($old_price_ids)>1){
			
								//We do not touch multiple child prices. Because in the parent list, we see no price, the gui is
								//missing to reflect the information properly.
								$pricesToStore = false;
								$old_price_ids = array();
							} else {
								unset($data['mprices']['product_override_price'][$k]);
								unset($pricesToStore['product_override_price']);
								unset($data['mprices']['override'][$k]);
								unset($pricesToStore['override']);
							}
			
						}
			
						//$data['mprices'][$k] = $data['virtuemart_product_id'];
						if($pricesToStore){
							$toUnset = array();
							if(is_array($old_price_ids)):
								foreach($old_price_ids as $key => $oldprice){
									if(array_search($pricesToStore['virtuemart_product_price_id'], $oldprice )){
										$pricesToStore = array_merge($oldprice,$pricesToStore);
										$toUnset[] = $key;
									}
								}
							endif;
			
							$this->updateXrefAndChildTables ($pricesToStore, 'product_prices',$isChild);
			
							foreach($toUnset as $key){
								unset( $old_price_ids[ $key ] );
							}
			
						}
					}
				}
			}
			
			if ( is_array($old_price_ids) && count($old_price_ids) ) {
				$oldPriceIdsSql = array();
				foreach($old_price_ids as $oldPride){
					$oldPriceIdsSql[] = $oldPride['virtuemart_product_price_id'];
				}
				// delete old unused Prices
				$this->_db->setQuery( 'DELETE FROM `#__virtuemart_product_prices` WHERE `virtuemart_product_price_id` in ("'.implode('","', $oldPriceIdsSql ).'") ');
				$this->_db->query();
				$err = $this->_db->getErrorMsg();
				if(!empty($err)){
					vmWarn('In store prodcut, deleting old price error',$err);
				}
			}
			
			if (!empty($data['childs'])) {
				foreach ($data['childs'] as $productId => $child) {
					$child['product_parent_id'] = $data['virtuemart_product_id'];
					$child['virtuemart_product_id'] = $productId;
					$this->store ($child, TRUE);
				}
			}
			
			if (!$isChild) {
			
				$data = $this->updateXrefAndChildTables ($data, 'product_shoppergroups');
			
				$data = $this->updateXrefAndChildTables ($data, 'product_manufacturers');
			
				if (!empty($data['categories']) && count ($data['categories']) > 0) {
					$data['virtuemart_category_id'] = $data['categories'];
				}
				else {
					$data['virtuemart_category_id'] = array();
				}
				$data = $this->updateXrefAndChildTables ($data, 'product_categories');
			
				// Update waiting list
				//TODO what is this doing?
				if (!empty($data['notify_users'])) {
					if ($data['product_in_stock'] > 0 && $data['notify_users'] == '1') {
						$waitinglist = VmModel::getModel ('Waitinglist');
						$waitinglist->notifyList ($data['virtuemart_product_id']);
					}
				}
			
				// Process the images
				$mediaModel = VmModel::getModel ('Media');
			
				$mediaModel->storeMedia ($data, 'product');
				$errors = $mediaModel->getErrors ();
				foreach ($errors as $error) {
					vmError ($error);
				}
			
			}
			
			return $product_data->virtuemart_product_id;
		}
		
		
		
		/*original VM*/
		/**
     * Store a product
     *
     * @author Max Milbers
     * @param $product given as reference
     * @param bool $isChild Means not that the product is child or not. It means if the product should be threated as child
     * @return bool
     */
	 
	 public function CBStore($product,$vmversion){
    //public function store (&$product) {
/*
		vRequest::vmCheckToken();

		if(!vmAccess::manager('product.edit')){
			vmError('You are not a vendor or administrator, storing of product cancelled');
			return FALSE;
		}*/

		if ($product) {
			$data = (array)$product;
		}
		
		
		//added
		$data['published'] = $product_data->published;
		
		
		$isChild = FALSE;
		if(!empty($data['isChild'])) $isChild = $data['isChild'];

		if (isset($data['intnotes'])) {
			$data['intnotes'] = trim ($data['intnotes']);
		}

		// Setup some place holders
		$product_data = $this->getTable ('products');

		if(!empty($data['virtuemart_product_id'])){
			$product_data -> load($data['virtuemart_product_id']);
		}
		/*if( (empty($data['virtuemart_product_id']) or empty($product_data->virtuemart_product_id)) and !vmAccess::manager('product.create')){
			vmWarn('Insufficient permission to create product');
			return false;
		}
		if(!vmAccess::manager('product.edit.state')){
			if( (empty($data['virtuemart_product_id']) or empty($product_data->virtuemart_product_id))){
				$data['published'] = 0;
			} else {
				$data['published'] = $product_data->published;
			}
		}*/

		//Set the decimals like product packaging
		foreach($this->decimals as $decimal){
			if (array_key_exists ($decimal, $data)) {
				if(!empty($data[$decimal])){
					$data[$decimal] = str_replace(',','.',$data[$decimal]);
					//vmdebug('Store product '.$data['virtuemart_product_id'].', set $decimal '.$decimal.' = '.$data[$decimal]);
				} else {
					$data[$decimal] = null;
					$product_data->$decimal = null;
					//vmdebug('Store product '.$data['virtuemart_product_id'].', set $decimal '.$decimal.' = null');
				}
			}
		}

		//We prevent with this line, that someone is storing a product as its own parent
		if(!empty($product_data->product_parent_id) and $product_data->product_parent_id == $data['virtuemart_product_id']){
			$product_data->product_parent_id = 0;
		}

		$stored = $product_data->bindChecknStore ($data, false);

		if(!$stored ){
			vmError('You are not an administrator or the correct vendor, storing of product cancelled');
			return FALSE;
		}

		$this->_id = $data['virtuemart_product_id'] = (int)$product_data->virtuemart_product_id;

		if (empty($this->_id)) {
			vmError('Product not stored, no id');
			return FALSE;
		}

		//We may need to change this, the reason it is not in the other list of commands for parents
		if (!$isChild) {
			$modelCustomfields = VmModel::getModel ('Customfields');
			$modelCustomfields->storeProductCustomfields ('product', $data, $product_data->virtuemart_product_id);
		}

		// Get old IDS
		$old_price_ids = $this->loadProductPrices($this->_id,array(0),false);

		if (isset($data['mprices']['product_price']) and count($data['mprices']['product_price']) > 0){

			foreach($data['mprices']['product_price'] as $k => $product_price){

				$pricesToStore = array();
				$pricesToStore['virtuemart_product_id'] = $this->_id;
				$pricesToStore['virtuemart_product_price_id'] = (int)$data['mprices']['virtuemart_product_price_id'][$k];

				if (!$isChild){
					//$pricesToStore['basePrice'] = $data['mprices']['basePrice'][$k];
					$pricesToStore['product_override_price'] = $data['mprices']['product_override_price'][$k];
					$pricesToStore['override'] = isset($data['mprices']['override'][$k])?(int)$data['mprices']['override'][$k]:0;
					$pricesToStore['virtuemart_shoppergroup_id'] = (int)$data['mprices']['virtuemart_shoppergroup_id'][$k];
					$pricesToStore['product_tax_id'] = (int)$data['mprices']['product_tax_id'][$k];
					$pricesToStore['product_discount_id'] = (int)$data['mprices']['product_discount_id'][$k];
					$pricesToStore['product_currency'] = (int)$data['mprices']['product_currency'][$k];
					$pricesToStore['product_price_publish_up'] = $data['mprices']['product_price_publish_up'][$k];
					$pricesToStore['product_price_publish_down'] = $data['mprices']['product_price_publish_down'][$k];
					$pricesToStore['price_quantity_start'] = (int)$data['mprices']['price_quantity_start'][$k];
					$pricesToStore['price_quantity_end'] = (int)$data['mprices']['price_quantity_end'][$k];
				}

				if (!$isChild and isset($data['mprices']['use_desired_price'][$k]) and $data['mprices']['use_desired_price'][$k] == "1") {
					if (!class_exists ('calculationHelper')) {
						require(VMPATH_ADMIN . DS . 'helpers' . DS . 'calculationh.php');
					}
					$calculator = calculationHelper::getInstance ();
					$pricesToStore['salesPrice'] = $data['mprices']['salesPrice'][$k];
					$pricesToStore['product_price'] = $data['mprices']['product_price'][$k] = $calculator->calculateCostprice ($this->_id, $pricesToStore);
					unset($data['mprices']['use_desired_price'][$k]);
				} else {
					if(isset($data['mprices']['product_price'][$k]) ){
						$pricesToStore['product_price'] = $data['mprices']['product_price'][$k];
					}

				}

				if ($isChild) $childPrices = $this->loadProductPrices($this->_id,array(0),false);

				if ((isset($pricesToStore['product_price']) and $pricesToStore['product_price']!='' and $pricesToStore['product_price']!=='0') || (isset($childPrices) and count($childPrices)>1)) {

					if ($isChild) {

						if(is_array($old_price_ids) and count($old_price_ids)>1){

							//We do not touch multiple child prices. Because in the parent list, we see no price, the gui is
							//missing to reflect the information properly.
							$pricesToStore = false;
							$old_price_ids = array();
						} else {
							unset($data['mprices']['product_override_price'][$k]);
							unset($pricesToStore['product_override_price']);
							unset($data['mprices']['override'][$k]);
							unset($pricesToStore['override']);
						}

					}

					if($pricesToStore){
						$toUnset = array();
						if (!empty($old_price_ids) and count($old_price_ids) ) {
							foreach($old_price_ids as $key => $oldprice){
								if($pricesToStore['virtuemart_product_price_id'] == $oldprice['virtuemart_product_price_id'] ){
									$pricesToStore = array_merge($oldprice,$pricesToStore);
									$toUnset[] = $key;
								}
							}
						}
						$this->updateXrefAndChildTables ($pricesToStore, 'product_prices',$isChild);

						foreach($toUnset as $key){
							unset( $old_price_ids[ $key ] );
						}
					}
				}
			}
		}
		if (!empty($old_price_ids) and count($old_price_ids) ) {
			$oldPriceIdsSql = array();
			foreach($old_price_ids as $oldPride){
				$oldPriceIdsSql[] = $oldPride['virtuemart_product_price_id'];
			}
			$db = JFactory::getDbo();
			// delete old unused Prices
			$db->setQuery( 'DELETE FROM `#__virtuemart_product_prices` WHERE `virtuemart_product_price_id` in ("'.implode('","', $oldPriceIdsSql ).'") ');
			$db->execute();
			$err = $db->getErrorMsg();
			if(!empty($err)){
				vmWarn('In store prodcut, deleting old price error',$err);
			}
		}

		if (!empty($data['childs'])) {
			foreach ($data['childs'] as $productId => $child) {
				if($productId!=$data['virtuemart_product_id']){

					if(empty($child['product_parent_id'])) $child['product_parent_id'] = $data['virtuemart_product_id'];
					$child['virtuemart_product_id'] = $productId;

					if(!empty($child['product_parent_id']) and $child['product_parent_id'] == $child['virtuemart_product_id']){
						$child['product_parent_id'] = 0;
					}

					$child['isChild'] = $this->_id;
					$this->store ($child);
				}
			}
		}

		if (!$isChild) {

			$data = $this->updateXrefAndChildTables ($data, 'product_shoppergroups');

			$data = $this->updateXrefAndChildTables ($data, 'product_manufacturers');

			if (!empty($data['categories']) && count ($data['categories']) > 0) {
				$data['virtuemart_category_id'] = $data['categories'];
			}
			else {
				$data['virtuemart_category_id'] = array();
			}
			$data = $this->updateXrefAndChildTables ($data, 'product_categories');

			// Update waiting list
			//TODO what is this doing?
			if (!empty($data['notify_users'])) {
				if ($data['product_in_stock'] > 0 && $data['notify_users'] == '1') {
					$waitinglist = VmModel::getModel ('Waitinglist');
					$waitinglist->notifyList ($data['virtuemart_product_id']);
				}
			}

			// Process the images
			$mediaModel = VmModel::getModel ('Media');
			$mediaModel->storeMedia ($data, 'product');

		}

		$cache = JFactory::getCache('com_virtuemart_cat_manus','callback');
		$cache->clean();
		
		return $product_data->virtuemart_product_id;
	}
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		public function CBstore2($product, $isChild = FALSE) {
	
			/*
			if ($product) {
				$data = (array)$product;
			}
			if (!class_exists ('Permissions')) require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'permissions.php');
			if (isset($data['intnotes'])) {
				$data['intnotes'] = trim ($data['intnotes']);
			}
			// Setup some place holders
			$product_data = $this->getTable ('products');
	
			//Set the product packaging
			if (array_key_exists ('product_packaging', $data)) {
				$data['product_packaging'] = str_replace(',','.',$data['product_packaging']);
			}
	
			//with the true, we do preloading and preserve so old values note by Max Milbers
		//	$product_data->bindChecknStore ($data, $isChild);
			
			$stored = $product_data->bindChecknStore ($data, TRUE);
			
			$errors = $product_data->getErrors ();
			if(!$stored or count($errors)>0){
				foreach ($errors as $error) {
					vmError ('Product store '.$error);
				}
				if(!$stored){
					vmError('You are not an administrator or the correct vendor, storing of product cancelled');
				}
				return FALSE;
			}
			
	
			$this->_id = $data['virtuemart_product_id'] = $product_data->virtuemart_product_id;
	
			if (empty($this->_id)) {
				vmError('Product not stored, no id');
				return FALSE;
			}
	
			//We may need to change this, the reason it is not in the other list of commands for parents
			if (!$isChild) {
				if (!empty($data['save_customfields'])) {
					if (!class_exists ('VirtueMartModelCustomfields')) {
						require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'customfields.php');
					}
					VirtueMartModelCustomfields::storeProductCustomfields ('product', $data, $product_data->virtuemart_product_id);
				}
			}
	
	 		//vmdebug('use_desired_price '.$this->_id.' '.$data['use_desired_price']);
			if (!$isChild and isset($data['use_desired_price']) and $data['use_desired_price'] == "1") {
	
				if (!class_exists ('calculationHelper')) {
					require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'calculationh.php');
				}
				$calculator = calculationHelper::getInstance ();
				$data['product_price'] = $calculator->calculateCostprice ($this->_id, $data);
				unset($data['use_desired_price']);
				// 			vmdebug('product_price '.$data['product_price']);
			}
			if (isset($data['product_price'])) {
				if ($isChild) {
					unset($data['product_override_price']);
					unset($data['override']);
				}
				$data = $this->CBupdateXrefAndChildTables ($data, 'product_prices');
			}
	
	
			if (!empty($data['childs'])) {
				foreach ($data['childs'] as $productId => $child) {
					$child['product_parent_id'] = $data['virtuemart_product_id'];
					$child['virtuemart_product_id'] = $productId;
					$this->store ($child, TRUE);
				}
			}
	
			if (!$isChild) {
	
				$data = $this->CBupdateXrefAndChildTables ($data, 'product_shoppergroups');
	
				$data = $this->CBupdateXrefAndChildTables ($data, 'product_manufacturers');
	
				if (!empty($data['categories']) && count ($data['categories']) > 0) {
					$data['virtuemart_category_id'] = $data['categories'];
				}
				else {
					$data['virtuemart_category_id'] = array();
				}
				$data = $this->CBupdateXrefAndChildTables ($data, 'product_categories', TRUE);
	
				// Update waiting list
				//TODO what is this doing?
				if (!empty($data['notify_users'])) {
					if ($data['product_in_stock'] > 0 && $data['notify_users'] == '1') {
						$waitinglist = VmModel::getModel ('Waitinglist');
						$waitinglist->notifyList ($data['virtuemart_product_id']);
					}
				}
	
				// Process the images
				$mediaModel = VmModel::getModel ('Media');
	
				$mediaModel->storeMedia ($data, 'product');
				$errors = $mediaModel->getErrors ();
				foreach ($errors as $error) {
					vmError ($error);
				}
	
			}
			return $product_data->virtuemart_product_id;
			*/
			
			if (class_exists( 'VmConfig' )){				
				//JRequest::checkToken () or jexit ('Invalid Token');						
				if ($product) {
					$data = (array)$product;
				}
		
				/*if (!class_exists ('Permissions')) require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'permissions.php');
		
				
				$perm = Permissions::getInstance();
				$superVendor = $perm->isSuperVendor();
				if(empty($superVendor)){
					vmError('You are not a vendor or administrator, storing of product cancelled');
					return FALSE;
				}*/
		
				if (isset($data['intnotes'])) {
					$data['intnotes'] = trim ($data['intnotes']);
				}
				// Setup some place holders
				$product_data = $this->getTable ('products');
		
				//Set the product packaging
				if (array_key_exists ('product_packaging', $data)) {
					$data['product_packaging'] = str_replace(',','.',$data['product_packaging']);
				}
		
				//with the true, we do preloading and preserve so old values note by Max Milbers
			//	$product_data->bindChecknStore ($data, $isChild);
		
				$stored = $product_data->bindChecknStore ($data, TRUE);
		
				$errors = $product_data->getErrors ();
				if(!$stored or count($errors)>0){
					foreach ($errors as $error) {
						vmError ('Product store '.$error);
					}
					if(!$stored){
						vmError('You are not an administrator or the correct vendor, storing of product cancelled');
					}
					return FALSE;
				}
		
		
				$this->_id = $data['virtuemart_product_id'] = (int)$product_data->virtuemart_product_id;
		
				if (empty($this->_id)) {
					vmError('Product not stored, no id');
					return FALSE;
				}
		
				//We may need to change this, the reason it is not in the other list of commands for parents
				/*if (!$isChild) {
					if (!empty($data['save_customfields'])) {
						if (!class_exists ('VirtueMartModelCustomfields')) {
							require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'customfields.php');
						}
						VirtueMartModelCustomfields::storeProductCustomfields ('product', $data, $product_data->virtuemart_product_id);
					}
				}*/
		
				
				// Get old IDS
				$this->_db->setQuery( 'SELECT `virtuemart_product_price_id` FROM `#__virtuemart_product_prices` WHERE virtuemart_product_id ='.$this->_id );
				$old_price_ids = $this->_db->loadResultArray();
				
				$_db =JFactory::getDBO();
		      	$_query = 'select vendor_currency from #__virtuemart_vendors limit 1';
		      	$_db->setQuery( $_query);
		      	$currency=$_db->loadResult();
				
		
				foreach($data['mprices']['product_price'] as $k => $product_price){
				
					$pricesToStore = array();
					$pricesToStore['virtuemart_product_id'] = $this->_id;
					$pricesToStore['virtuemart_product_price_id'] = (int)$data['mprices']['virtuemart_product_price_id'][$k];
		
		
					if (!$isChild){
						//$pricesToStore['basePrice'] = $data['mprices']['basePrice'][$k];
						$pricesToStore['product_override_price'] = $data['mprices']['product_override_price'][$k];
						$pricesToStore['override'] = (int)$data['mprices']['override'][$k];
						$pricesToStore['virtuemart_shoppergroup_id'] = (int)$data['mprices']['virtuemart_shoppergroup_id'][$k];
						$pricesToStore['product_tax_id'] = (int)$data['mprices']['product_tax_id'][$k];
						$pricesToStore['product_discount_id'] = (int)$data['mprices']['product_discount_id'][$k];
						//$pricesToStore['product_currency'] = (int)$data['mprices']['product_currency'][$k];
						$pricesToStore['product_currency'] = $currency;
						$pricesToStore['product_price_publish_up'] = $data['mprices']['product_price_publish_up'][$k];
						$pricesToStore['product_price_publish_down'] = $data['mprices']['product_price_publish_down'][$k];
						$pricesToStore['price_quantity_start'] = (int)$data['mprices']['price_quantity_start'][$k];
						$pricesToStore['price_quantity_end'] = (int)$data['mprices']['price_quantity_end'][$k];				
					}
		
					
					if (!$isChild and isset($data['mprices']['use_desired_price'][$k]) and $data['mprices']['use_desired_price'][$k] == "1") {
						if (!class_exists ('calculationHelper')) {
							require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'calculationh.php');
						}
						$calculator = calculationHelper::getInstance ();
						$pricesToStore['salesPrice'] = $data['mprices']['salesPrice'][$k];
						$pricesToStore['product_price'] = $data['mprices']['product_price'][$k] = $calculator->calculateCostprice ($this->_id, $pricesToStore);
						unset($data['mprices']['use_desired_price'][$k]);
					} else {
						if(isset($data['mprices']['product_price'][$k]) ){
							$pricesToStore['product_price'] = $data['mprices']['product_price'][$k];
						}
		
					}
		
					if (isset($data['mprices']['product_price'][$k]) and $data['mprices']['product_price'][$k]!='') {
		
						if ($isChild) {
							unset($data['mprices']['product_override_price'][$k]);
							unset($pricesToStore['product_override_price']);
							unset($data['mprices']['override'][$k]);
							unset($pricesToStore['override']);
						}
		
						//$data['mprices'][$k] = $data['virtuemart_product_id'];
		
						$this->CBupdateXrefAndChildTables ($pricesToStore, 'product_prices',$isChild);
		
						$key = array_search($pricesToStore['virtuemart_product_price_id'], $old_price_ids );
						if ($key !== false ) unset( $old_price_ids[ $key ] );
		
					}
				}
		
		
				if ( count($old_price_ids) ) {
					// delete old unused Customfields
					$this->_db->setQuery( 'DELETE FROM `#__virtuemart_product_prices` WHERE `virtuemart_product_price_id` in ("'.implode('","', $old_price_ids ).'") ');
					$this->_db->query();
				}
		
				if (!empty($data['childs'])) {
					foreach ($data['childs'] as $productId => $child) {
						$child['product_parent_id'] = $data['virtuemart_product_id'];
						$child['virtuemart_product_id'] = $productId;
						$this->store ($child, TRUE);
					}
				}
		
				if (!$isChild) {
		
					$data = $this->CBupdateXrefAndChildTables ($data, 'product_shoppergroups');
		
					$data = $this->CBupdateXrefAndChildTables ($data, 'product_manufacturers');
		
					if (!empty($data['categories']) && count ($data['categories']) > 0) {
						$data['virtuemart_category_id'] = $data['categories'];
					}
					else {
						$data['virtuemart_category_id'] = array();
					}
					$data = $this->CBupdateXrefAndChildTables ($data, 'product_categories');
		
					// Update waiting list
					//TODO what is this doing?
					if (!empty($data['notify_users'])) {
						if ($data['product_in_stock'] > 0 && $data['notify_users'] == '1') {
							$waitinglist = VmModel::getModel ('Waitinglist');
							$waitinglist->notifyList ($data['virtuemart_product_id']);
						}
					}
				}
		
				return $product_data->virtuemart_product_id;
			}
		}
		
		private function CBupdateXrefAndChildTables ($data, $tableName, $preload = FALSE) {
			
			//First we load the xref table, to get the old data
			$product_table_Parent = $this->getTable ($tableName);
			//We must go that way, because the load function of the vmtablexarry
			// is working different.
			if($preload){
				//$product_table_Parent->setOrderable('ordering',false);
				$orderingA = $product_table_Parent->load($data['virtuemart_product_id']);
				if(isset($orderingA)&&isset($orderingA[0])){
					$product_table_Parent->ordering = $orderingA[0];
				}
				//$product_table_Parent->ordering = $product_table_Parent->load($data['virtuemart_product_id']);
				//vmdebug('my ordering ',$product_table_Parent->ordering);
			}
			$product_table_Parent->bindChecknStore ($data);
			$errors = $product_table_Parent->getErrors ();
			foreach ($errors as $error) {
				vmError ($error);
			}
			return $data;
			
		}
	}
		
}