<?php
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */

// Check to ensure this file is included in Joomla!
defined ( '_JEXEC' ) or die ();

jimport ( 'joomla.application.component.model' );

//require_once (JPATH_COMPONENT_ADMINISTRATOR . DS . 'helper.php');
require_once (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_calcbuilder' . DS . 'helper.php');
require 'main.model.php';
class wrapperMainModel extends CalcbuilderMainModel {
	public function _getTableObject($tablename, $where = null, $order = null, $isList = false, $isPaginated = false, $isOrdered = false) {
		return $this->_getTableObjectWrapper ( $tablename, $where, $order, $isList, $isPaginated, $isOrdered, false );
	}
	public function _getTableObjectArray($tablename, $where = null, $order = null, $isList = false, $isPaginated = false, $isOrdered = false) {
		return $this->_getTableObjectWrapper ( $tablename, $where, $order, $isList, $isPaginated, $isOrdered, true );
	}
	private function _getTableObjectWrapper($tablename, $where = null, $order = null, $isList = false, $isPaginated = false, $isOrdered = false, $returnArray = false) {
		$ret = new tableObject ();
		$_search = MSHelper::__requestGetVarWrapper ( '_search', null );
		$_order = MSHelper::__requestGetVarWrapper ( '_order', null );
		$db = JFactory::getDbo ();
		$query = $db->getQuery ( true );
		$query->select ( '*' )->from ( $tablename );
		if ($where != null)
			$query->where ( $where );
		elseif ($_search != null)
			$query->where ( $this->_createWhereSearch ( $tablename, $_search ), 'OR' );
		if ($order != null)
			$query->order ( $order );
		elseif ($_order && $isOrdered)
			$query->order ( $_order );
		try {
			if ($isPaginated) {
				jimport ( 'joomla.html.pagination' );
				$mainframe = JFactory::getApplication ();
				$limit = MSHelper::__requestGetVarWrapper ( 'limit', $mainframe->getCfg ( 'list_limit' ) );
				if (MSHelper::__requestGetVarWrapper ( 'limit' ) != null && MSHelper::__requestGetVarWrapper ( 'limit' ) == 0)
					$limit = 0;
				$limitstart = MSHelper::__requestGetVarWrapper ( 'limitstart', 0 );
				$total = $this->_getCount ( $tablename, $where, $_search );
				$ret->setProperty ( 'pagination', new JPagination ( $total, $limitstart, $limit ) );
				$db->setQuery ( $query, $limitstart, $limit );
			} else {
				$db->setQuery ( $query );
			}
		} catch ( Exception $e ) {
			if (JError::$legacy) {
				JError::setErrorHandling ( E_ERROR, 'die' );
				return JError::raiseError ( 500, JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			} else {
				throw new Exception ( JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			}
		}
		if ($isList) {
			if ($returnArray)
				$ret->setProperty ( 'data', $db->loadAssocList () );
			else
				$ret->setProperty ( 'data', $db->loadObjectList () );
		} else {
			if ($returnArray)
				$ret->setProperty ( 'data', $db->loadAssoc () );
			else
				$ret->setProperty ( 'data', $db->loadObject () );
		}
		$ret->setProperty ( 'order', $_order ); // order
		return $ret;
	}
	public function _getQueryObject($selects, $tablename, $joins, $where = null, $order = null, $isList = false, $isPaginated = false, $isOrdered = false, $globalSearch = false) {
		$ret = new tableObject ();
		$_order = MSHelper::__requestGetVarWrapper ( '_order', null );
		$_search = MSHelper::__requestGetVarWrapper ( '_search', null );
		$db = JFactory::getDbo ();
		$query = $db->getQuery ( true );
		$selectQuoted = array ();
		if (is_array ( $selects )) {
			foreach ( $selects as $sel ) {
				$selectQuoted [] = $db->quoteName ( $sel );
			}
		} else {
			$selectQuoted [] = $db->quoteName ( $selects );
		}
		$query->select ( $selectQuoted )->from ( $tablename );
		if ($joins != null) {
			foreach ( $joins as $join ) {
				$query->join ( $join ['type'], $join ['main'] );
			}
		}
		if ($where != null)
			$query->where ( $where );
		elseif ($_search != null) {
			if (! $globalSearch)
				$query->where ( $this->_createWhereSearch ( $tablename, $_search, $selects ), 'OR' );
			else
				$query->where ( $this->_createWhereSearch ( $tablename, $_search ), 'OR' );
		}
		if ($order != null)
			$query->order ( $order );
		elseif ($_order && $isOrdered)
			$query->order ( $_order );
		try {
			if ($isPaginated) {
				jimport ( 'joomla.html.pagination' );
				$mainframe = JFactory::getApplication ();
				$limit = MSHelper::__requestGetVarWrapper ( 'limit', $mainframe->getCfg ( 'list_limit' ) );
				$limitstart = MSHelper::__requestGetVarWrapper ( 'limitstart', 0 );
				$total = $this->_getCount ( $tablename, $where, $_search );
				$ret->setProperty ( 'pagination', new JPagination ( $total, $limitstart, $limit ) );
				$db->setQuery ( $query, $limitstart, $limit );
			} else {
				$db->setQuery ( $query );
			}
		} catch ( Exception $e ) {
			if (JError::$legacy) {
				JError::setErrorHandling ( E_ERROR, 'die' );
				return JError::raiseError ( 500, JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			} else {
				throw new Exception ( JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			}
		}
		if ($isList)
			$ret->setProperty ( 'data', $db->loadObjectList () );
		else
			$ret->setProperty ( 'data', $db->loadObject () );
		$ret->setProperty ( 'order', $_order ); // order
		return $ret;
	}
	public function _store($tablename, $isUpdate = false, $id = null) {
		$result = false;
		$cols = $this->_getColumnsNames ( $tablename );
		$ins = new stdClass ();
		foreach ( $cols as $col ) {
			$ins->$col = MSHelper::__requestGetVarWrapper ( $col, null, 'request', 'string', JREQUEST_ALLOWRAW );
		}
		try {
			if ($isUpdate) {
				JFactory::getDbo ()->updateObject ( $tablename, $ins, $id );
				$result = $ins->$id;
			} else {
				JFactory::getDbo ()->insertObject ( $tablename, $ins );
				$result = JFactory::getDbo ()->insertid ();
			}
		} catch ( Exception $e ) {
			if (JError::$legacy) {
				JError::setErrorHandling ( E_ERROR, 'die' );
				return JError::raiseError ( 500, JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			} else {
				throw new Exception ( JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			}
		}
		return $result;
	}
	public function _storeArray($tablename, $data, $isUpdate = false, $id = null) {
		$result = false;
		$cols = $this->_getColumnsNames ( $tablename );
		$ins = new stdClass ();
		foreach ( $cols as $col ) {
			$ins->$col = $data [$col];
		}
		try {
			if ($isUpdate) {
				JFactory::getDbo ()->updateObject ( $tablename, $ins, $id );
				$result = $ins->$id;
			} else {
				JFactory::getDbo ()->insertObject ( $tablename, $ins );
				$result = JFactory::getDbo ()->insertid ();
			}
		} catch ( Exception $e ) {
			if (JError::$legacy) {
				JError::setErrorHandling ( E_ERROR, 'die' );
				return JError::raiseError ( 500, JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			} else {
				throw new Exception ( JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			}
		}
		return $result;
	}
	public function _insertValues($tablename, $arrdata) {
		$result = true;
		$db = JFactory::getDbo ();
		$dataInsert = array ();
		foreach ( $arrdata as $data ) {
			$dataInsert [] = $db->quote ( $data );
		}
		$query = $db->getQuery ( true );
		$query->insert ( $db->quoteName ( $tablename ) )->values ( implode ( ',', $dataInsert ) );
		$db->setQuery ( $query );
		try {
			$result = $db->query ();
		} catch ( Exception $e ) {
			if (JError::$legacy) {
				JError::setErrorHandling ( E_ERROR, 'die' );
				return JError::raiseError ( 500, JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			} else {
				throw new Exception ( JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			}
			$result = false;
		}
		return $result;
	}
	public function _updateArray($tablename, $fields, $conditions) {
		$db = JFactory::getDbo ();
		$query = $db->getQuery ( true );
		$query->update ( $db->quoteName ( $tablename ) )->set ( $fields )->where ( $conditions );
		try {
			$db->setQuery ( $query );
			$db->query ();
		} catch ( Exception $e ) {
			if (JError::$legacy) {
				JError::setErrorHandling ( E_ERROR, 'die' );
				return JError::raiseError ( 500, JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			} else {
				throw new Exception ( JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			}
		}
	}
	public function _delete($tablename, $conditions = null) {
		$result = false;
		$db = JFactory::getDbo ();
		$query = $db->getQuery ( true );
		$query->delete ( $db->quoteName ( $tablename ) );
		if ($conditions != null)
			$query->where ( $conditions );
		try {
			$db->setQuery ( $query );
			$db->query ();
		} catch ( Exception $e ) {
			if (JError::$legacy) {
				JError::setErrorHandling ( E_ERROR, 'die' );
				return JError::raiseError ( 500, JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			} else {
				throw new Exception ( JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			}
		}
	}
	public function _getCount($tablename, $where, $_search) {
		$db = JFactory::getDbo ();
		$query = $db->getQuery ( true );
		$query->select ( 'count(*)' )->from ( $tablename );
		if ($where != null)
			$query->where ( $where );
		elseif ($_search != null)
			$query->where ( $this->_createWhereSearch ( $tablename, $_search ), 'OR' );
		$ret = null;
		try {
			$db->setQuery ( $query );
			$ret = $db->loadResult ();
		} catch ( Exception $e ) {
			if (JError::$legacy) {
				JError::setErrorHandling ( E_ERROR, 'die' );
				return JError::raiseError ( 500, JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			} else {
				throw new Exception ( JText::sprintf ( 'MS_MODEL_WRAPPER_ERROR', $e->getMessage () ) );
			}
		}
		return $ret;
	}
	public function _getColumnsNames($tablename) {
		$db = JFactory::getDbo ();
		$db->getTableColumns ( $tablename );
		return $db->loadColumn ( 0 );
	}
	public function _getColumns($tablename) {
		$db = JFactory::getDbo ();
		$db->getTableColumns ( $tablename );
		return $db->loadObjectList ();
	}
	private function _createWhereSearch($tablename, $value, $filtercols = null) {
		$db = JFactory::getDbo ();
		$ret = array ();
		$cols = $this->_getColumnsNames ( $tablename );
		$value = '%' . MSHelper::__getEscapedWrapper ( $value, true ) . '%';
		foreach ( $cols as $col ) {
			if ($filtercols == null || ($filtercols != null && in_array ( $col, $filtercols ))) {
				$ret [] = $col . ' like ' . $db->quote ( $value );
			}
		}
		return $ret;
	}
}
class tableObject {
	private $data = null;
	private $pagination = null;
	public function setProperty($name, $newval) {
		$this->$name = $newval;
	}
	public function getProperty($name) {
		return $this->$name;
	}
}
?>