CB(document).ready(function() {
	CB.validator.addMethod("cb_number", function(value, element, params) {
		var rtext="^(\\d|-)?(\\d|"+params[0]+")*(\\"+params[1]+")?(\\d)*$"
		var regex=new RegExp(rtext, 'g');
		return regex.test(value);	
	}, getLangTrads("NUMBER_INCORRECT"));
	
	CB.validator.addMethod("cb_number_decimal", function(value, element, params) {
		value_temp=replaceAll( value, params[0], '' );
		var rtext="^(\\d|-)?[0-9]*["+params[1]+"]?[0-9]{0,"+params[2]+"}$"
		var regex=new RegExp(rtext, 'g');
		return regex.test(value_temp);	
	}, CB.validator.format(getLangTrads("VALUE_DECIMAL")));
		
	CB.validator.addMethod("cb_between", function(value, element, params) {		
		if (value=='') return true;
		value=getNumber(value);
		return !(value<getNumber(params[0]) || value>getNumber(params[1]));	
	}, CB.validator.format(getLangTrads("VALUE_BETWEEN")));
	
	CB.validator.addMethod("cb_greater", function(value, element, params) {
		if (value=='') return true;
		value=getNumber(value);
		return value>getNumber(params[0]);	
	}, CB.validator.format(getLangTrads("VALUE_GREATER")));
	
	CB.validator.addMethod("cb_smaller", function(value, element, params) {
		if (value=='') return true;
		value=getNumber(value);
		return value<getNumber(params[0]);	
	}, CB.validator.format(getLangTrads("VALUE_SMALLER")));
	
	
	/** 
	 * Custom Methods
	 */	
	CB.validator.addMethod("cb_option_non_first", function(value, element, params) {
		if (CB(element).find('option:first').attr('selected')) return false;
		return true;
	}, CB.validator.format(getLangTrads("OPTION_REQUIRED")));
	
	CB.validator.addMethod("cb_requiredupload", function(value, element, params) {
		if (!CB(element).prop('filesuploaded')||CB(element).prop('filesuploaded')<1) return false;
		return true;
	}, CB.validator.format(getLangTrads("UPLOADED_REQUIRED")));
	
	CB.validator.addClassRules({
		cb_option_non_first : { cb_option_non_first : true },
		cb_requiredupload : { cb_requiredupload : true}
	});
});
