<?php
defined ( '_JEXEC' ) or die ( 'Restricted access' ); // no direct access
/*
 * @component Calc Builder 
 * @copyright Copyright (C) January 2017. 
 * @license GPL 3.0 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details. 
 * See <http://www.gnu.org/licenses/>. 
 * More info www.moonsoft.es 
 * gestion@moonsoft.es
 */
jimport ( 'joomla.html.html' );
jimport ( 'joomla.form.formfield' );
class JFormFieldPreferences extends JFormField {
	protected $type = 'Preferences';
	
	/**
	 * Method to get the field input markup.
	 *
	 * @return string field input markup.
	 * @since 1.6
	 */
	protected function getInput() {
		// Initialize variables.
		$html = array ();
		$attr = '';
		
		// Initialize some field attributes.
		$attr .= $this->element ['class'] ? ' class="' . ( string ) $this->element ['class'] . '"' : '';
		
		// To avoid user's confusion, readonly="true" should imply disabled="true".
		if (( string ) $this->element ['readonly'] == 'true' || ( string ) $this->element ['disabled'] == 'true') {
			$attr .= ' disabled="disabled"';
		}
		
		$attr .= $this->element ['size'] ? ' size="' . ( int ) $this->element ['size'] . '"' : '';
		$attr .= $this->multiple ? ' multiple="multiple"' : '';
		
		// Initialize JavaScript field attributes.
		$attr .= $this->element ['onchange'] ? ' onchange="' . ( string ) $this->element ['onchange'] . '"' : '';
		
		// Get the field options.
		$options = ( array ) $this->getOptions ();
		
		// Create a read-only list (no name) with a hidden input to store the value.
		if (( string ) $this->element ['readonly'] == 'true') {
			$html [] = JHtml::_ ( 'select.genericlist', $options, '', trim ( $attr ), 'value', 'text', $this->value, $this->id );
			$html [] = '<input type="hidden" name="' . $this->name . '" value="' . $this->value . '"/>';
		} 		// Create a regular list.
		else {
			$html [] = JHtml::_ ( 'select.genericlist', $options, $this->name, trim ( $attr ), 'value', 'text', $this->value, $this->id );
		}
		
		return implode ( $html );
	}
	
	/**
	 * Method to get the field options.
	 *
	 * @return array field option objects.
	 * @since 1.6
	 */
	protected function getOptions() {
		// Initialize variables.
		$options = array ();
		$query = 'SELECT id as value, name as text' . ' FROM #__calcbuilder_utility ' . ' ORDER BY name';
		$db = JFactory::getDBO ();
		$db->setQuery ( $query );
		$optionsList = $db->loadObjectList ();
		
		foreach ( $optionsList as $option ) {
			// Create a new option object based on the <option /> element.
			$tmp = JHtml::_ ( 'select.option', $option->value, JText::alt ( trim ( ( string ) $option->text ), preg_replace ( '/[^a-zA-Z0-9_\-]/', '_', $this->fieldname ) ), 'value', 'text' );
			
			// Add the option object to the result set.
			$options [] = $tmp;
		}
		reset ( $options );
		return $options;
	}
}
?>
