<?php
/**
 * obInstagramFeed module
 * @version 1.0
 * @author Phong Lo <phonglq@foobla.com>
 * @link http://foobla.com
 * @Copyright (C) 2013 foobla.com. All Rights Reserved.
 * @license GNU General Public License version 2, see http://www.gnu.org/licenses/gpl-2.0.html
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.html.parameter' );
$ds = DIRECTORY_SEPARATOR;

class JFormFieldIConnect extends JFormField {
	protected $type 	= 'IConnect';
	protected $config 	= null;

	protected function getInput() {
		$app 			= JFactory::getApplication();
		$mod_id 		= $app->input->get('id');
		$redirect_url 	= JUri::root().'index.php?option=com_ajax&module=obinstagramfeed&method=getCode&format=raw';
		$redirect_uri 	= urlencode( $redirect_url );
		$form_control 	= $this->formControl;
		$script = <<<MIT

		function obInstagramGetCode(){
			// get client_id
			var client_id = jQuery('#{$form_control}_params_client_id').val();
			// get redirect_uri
			var redirect_uri = '{$redirect_uri}';
			// create authorization URL
			var auth_url = 'https://api.instagram.com/oauth/authorize/?client_id='+client_id+'&redirect_uri='+redirect_uri+'&response_type=code&scope=public_content';
			var leftPos = 0
			var topPos = 0
			if ( screen ) {
				leftPos = (screen.width / 2) - 251
				topPos = (screen.height / 2) - 162
			}
			ElementWindow = window.open( auth_url, "_blank", "status=0,toolbar=0,width=502,height=325,left="+leftPos+",top="+topPos);
		}

		function obInstagramGetClientID(){
			var client_id = jQuery('#{$form_control}_params_client_id').val();
			return client_id;
		}

		function obInstagramGetClientSecret(){
			var client_secret = jQuery('#{$form_control}_params_client_secret').val();
			return client_secret;
		}

		function obInstagramGetModuleId(){
			return {$mod_id};
		}
		
		function obInstagramSaveAccessToken(access_token){
			 jQuery('#{$form_control}_params_access_token').val(access_token);
			 Joomla.submitbutton("module.apply");
		}

MIT;
		$doc = JFactory::getDocument();
		$doc->addScriptDeclaration( $script );

		$html = '<a class="btn" href="javascript:obInstagramGetCode()">getAccessToken</a>';
		$html .= '<br/>Redirect Uri: <br/><textarea readonly="readonly" rows="5">'.$redirect_url.'</textarea>';
		return $html;
	}

}
