<?php
/**
 * obInstagramFeed module
 * @version 1.0
 * @author Phong Lo <phonglq@foobla.com>
 * @link http://foobla.com
 * @Copyright (C) 2013 foobla.com. All Rights Reserved.
 * @license GNU General Public License version 2, see http://www.gnu.org/licenses/gpl-2.0.html
 */
 
defined('_JEXEC') or die;

class modObInstagramFeedHelper
{
	public static function getInstaPhotos( $access_token, $iuserid )
	{
		$url = 'https://api.instagram.com/v1/users/' . $iuserid . '/media/recent/?access_token=' . $access_token;
		$data = self::sendRequest( $url );

		//~ $ch = curl_init('https://api.instagram.com/v1/users/' . $iuserid . '/media/recent/?access_token=' . $access_token);
		//~ curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		//~ curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		//~ $data = curl_exec($ch);
		$content = json_decode($data);
		$ph_count = count($content->data);
		$rows = array();
		for ($i = 0; $i < $ph_count; $i++) {
			$rows[$i]["link"] = $content->data[$i]->link;
			$rows[$i]["standard_resolution"] = $content->data[$i]->images->standard_resolution->url;
			$rows[$i]["low_resolution"] = $content->data[$i]->images->low_resolution->url;
			$rows[$i]["thumbnail"] = $content->data[$i]->images->thumbnail->url;
		}
		return $rows;
	}
	
	public static function searchUserAjax(){
		$app 	= JFactory::getApplication();
		$q 		= $app->input->get('q');
		$mod_id = $app->input->get('mod_id');
		$config = self::getConfig($mod_id);
		$access_token	= $config->get('access_token');
		$url 	= 'https://api.instagram.com/v1/users/search?q='.$q.'&access_token='.$access_token;
		$res 	= self::sendRequest($url);
		$datas 	= json_decode($res,true);

		if(!isset($datas['meta']['code'])||(int)$datas['meta']['code']!==200) {
			echo json_encode(array());
			return;
		}

		$users = empty($datas['data']) ? array() : $datas['data'];
		echo json_encode($users);
	}
	
	public static function getUserInforAjax(){
		$app 	= JFactory::getApplication();
		$access_token = $app->input->get('tk');
		$url 	= 'https://api.instagram.com/v1/users/self/?access_token='.$access_token;
		$res 	= self::sendRequest($url);
		$datas 	= json_decode($res,true);

		if(!isset($datas['meta']['code'])||(int)$datas['meta']['code']!==200) {
			echo json_encode(array());
			return;
		}

		$users = empty($datas['data']) ? array() : $datas['data'];
		echo json_encode(array($users));
	}

	public static function  getCodeAjax(){
		$app = JFactory::getApplication();
		$code = $app->input->get('code');
		$redirect_url = JUri::root().'index.php?option=com_ajax&module=obinstagramfeed&method=getAccessToken&format=raw';
		$html = <<<MIT
			<html>
				<head>
					<script>
						var mod_id = window.opener.obInstagramGetModuleId();
						var code = '{$code}';
						var get_access_token_url = '{$redirect_url}'+'&mod_id='+mod_id+'&code='+code;
						if(code){
							window.location.href = get_access_token_url;
						}else{
							console.log(code);
						}
					</script>
				</head>
				<body>
					
				</body>
			</html>
MIT;
		echo $html;
		exit();
	}

	public static function  getAccessTokenAjax(){
		$app 	= JFactory::getApplication();
		$mod_id = $app->input->get('mod_id');
		$code 	= $app->input->get('code');
		$config = self::getConfig($mod_id);
		
		$redirect_url = JUri::root().'index.php?option=com_ajax&module=obinstagramfeed&method=getCode&format=raw';
		$client_id = $config->get('client_id');
		$client_secret = $config->get('client_secret');
		
		
		$data = array();
		$data['client_id'] = $client_id;
		$data['client_secret'] = $client_secret;
		$data['grant_type'] = 'authorization_code';
		$data['redirect_uri'] = urlencode($redirect_url);
		$data['code'] = $code;
    
		$url = 'https://api.instagram.com/oauth/access_token';
		
		$res = self::sendRequest($url, $data, 'POST');
		$access_token_arr = json_decode($res, true);
		$access_token = $access_token_arr['access_token'];
		$html = <<<MIT
			<html>
				<head>
					<script>
						var access_token = '{$access_token}';
						window.opener.obInstagramSaveAccessToken(access_token);
						window.close();
					</script>
				</head>
				<body>
					
				</body>
			</html>
MIT;
		echo $html;
		exit();
		
		
	}
	
	public static function sendRequest( $url, $data=array(), $method='' ) {
			$app = JFactory::getApplication();
			$ch 	= curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		#	curl_setopt($ch, CURLOPT_TIMEOUT, 100);
			if($method=='POST'){
				curl_setopt($ch, CURLOPT_POST, true);
		
				curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
				$res = curl_exec( $ch );
				if(curl_errno($ch))
				{
					$fields_string = '';
					foreach($data as $key=>$value) {
						$fields_string .= $key . '=' . $value . '&';
					}
					rtrim($fields_string,'&');
					curl_setopt( $ch, CURLOPT_POSTFIELDS, $fields_string);
					$res = curl_exec( $ch );
				}
			} else {
				$res = curl_exec( $ch );
			}
			if(curl_errno($ch))
			{
				curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
				$res = curl_exec($ch);
			}
			if(curl_errno($ch))
			{
				
			}
			curl_close($ch);
			return $res;
		}
	
	public static function getConfig($mod_id){
		$db = JFactory::getDbo();
		$sql = 'SELECT `params` FROM `#__modules` WHERE `id`='.$mod_id;
		$db->setQuery($sql);
		$params_str = $db->loadResult();
		$params = new Joomla\Registry\Registry( $params_str );
		return $params;
	}
    
}
