<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  ob_countdown
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

/**
 * Contact Plugin
 *
 * @since  3.2
 */
class plgSystemOb_countdown extends JPlugin
{
	/**
	 * Database object
	 *
	 * @var    JDatabaseDriver
	 * @since  3.3
	 */
	protected $db;

	/**
	 * Plugin that retrieves contact information for contact
	 *
	 * @param   string   $context  The context of the content being passed to the plugin.
	 * @param   mixed    &$row     An object with a "text" property
	 * @param   mixed    $params   Additional parameters. See {@see PlgContentContent()}.
	 * @param   integer  $page     Optional page number. Unused. Defaults to zero.
	 *
	 * @return  boolean	True on success.
	 */
	public function __construct( & $subject, $config ) {
		parent::__construct( $subject, $config );
		$this->loadLanguage();
	}

	public function onBeforeCompileHead() {
		$app = JFactory::getApplication( 'site' );
		if( $app->isSite() ) {
			$doc = JFactory::getDocument();
			if ( ! $doc ) {

				return;
			}
			$doc->addScript( JURI::root() . 'plugins/system/ob_countdown/assets/js/jquery.mb-comingsoon.min.js' );
			$doc->addStyleSheet( JURI::root() . 'plugins/system/ob_countdown/assets/css/ob_countdown.css' );
		}

		return;
	}

	public function onAfterRender(){
		$app = JFactory::getApplication( 'site' );
		if ( $app->isAdmin() ) {
			return;
		}
		$regex = '/\[ob_countdown[^\]]*\]/ui';
		$body   = JResponse::getBody();
		$output = $body;
		preg_match_all( $regex, $output, $matches );
		if( count( $matches[0] ) == 0 ) {
			return;
		}
		$doc = JFactory::getDocument();
		if ( ! $doc ) {
			return;
		}
		foreach( $matches[0] as $key=>$match ) {
			preg_match('/date="([^"]*)"/ui', $match, $date_info);
			if( ! isset( $date_info[1] ) ) {
				$output = str_replace( $match, '', $output );
				continue;
			}
			$date_end = strtotime( $date_info[1] );
			$date     = JFactory::getDate();
			$date_current = $date->format( 'Y-m-d H:i:s' );
			if( strtotime( $date_current ) >= $date_end ) {
				$output = str_replace( $match, '', $output );
				continue;
			}
			$id_property = 'coming-soon-counter-' . $key;
			$count_down = '<div id="' . $id_property . '"></div>';
			$count_down .= '<script type="text/javascript">
								jQuery(function ($) {
				                    $("#' . $id_property . '").mbComingsoon({ expiryDate:  new Date(' . date( "Y",  $date_end ) . ', ' . ( date( "m", $date_end ) - 1 ) . ', ' . date( "d", $date_end ) . ', ' . date( "G", $date_end ) . ',' . date( "i", $date_end ) . ', ' . date( "s", $date_end ) . '), speed:100 });
									setTimeout(function () {
										$(window).resize();
									}, 200);
								});
							</script>
			';

			$output = str_replace( $match, $count_down, $output );
			//echo'<pre>';print_r($count_down);die;
		}
		JResponse::setBody( $output );
		return true;
		//echo'<pre>';print_r(is_file(JURI::root() . 'plugins/system/ob_countdown/assets/js/jquery.mb-comingsoon.min.js'));die;
	}

	public function change_format_date( $old_date, $format = 'Y-m-d H:i:s' ) {
		$date     = JFactory::getDate($old_date);
		$new_date = $date->format( $format );

		return strtotime( $new_date );
	}
}
