<?php
/**
 * @package          cake-format
 * @version          $Id: obtemptag.php 216 2014-02-17 03:35:04Z tung $
 * @author           Tung Pham - foobla.com
 * @copyright    (c) 2007-2016 foobla.com. All rights reserved.
 * @license          GNU/GPL, see LICENSE
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
global $isJ25;
if ( ! $isJ25 && is_file( JPATH_SITE . DS . 'libraries' . DS . 'cms' . DS . 'form' . DS . 'field' . DS . 'tag.php' ) ) {
	require_once JPATH_SITE . DS . 'libraries' . DS . 'cms' . DS . 'form' . DS . 'field' . DS . 'tag.php';


//jimport('joomla.form.form.fields.list');
	class JFormFieldObtemptag extends JFormFieldTag {
		public $type = 'obtemptag';

		protected function getInput() {

			$html = parent::getInput();

			return $html;
		}

		public function getOptions(){
			$published = $this->element['published']? $this->element['published'] : array(0,1);

			$db    = JFactory::getDbo();
			$query = $db->getQuery(true)
				->select('DISTINCT a.alias AS value, a.path, a.title AS text, a.level, a.published, a.lft')
				->from('#__tags AS a')
				->join('LEFT', $db->qn('#__tags') . ' AS b ON a.lft > b.lft AND a.rgt < b.rgt')
				->where('a.path LIKE "cuisine%"');

			// Filter language
			if (!empty($this->element['language']))
			{
				$query->where('a.language = ' . $db->q($this->element['language']));
			}

			$query->where($db->qn('a.lft') . ' > 0');

			// Filter on the published state
			if (is_numeric($published))
			{
				$query->where('a.published = ' . (int) $published);
			}
			elseif (is_array($published))
			{
				JArrayHelper::toInteger($published);
				$query->where('a.published IN (' . implode(',', $published) . ')');
			}

			$query->order('a.lft ASC');

			// Get the options.
			$db->setQuery($query);

			try
			{
				$options = $db->loadObjectList();
			}
			catch (RuntimeException $e)
			{
				return array();
			}

			// Block the possibility to set a tag as it own parent
			if ($this->form->getName() == 'com_tags.tag')
			{
				$id   = (int) $this->form->getValue('id', 0);

				foreach ($options as $option)
				{
					if ($option->value == $id)
					{
						$option->disable = true;
					}
				}
			}

			// Prepare nested data
			if ($this->isNested())
			{
				$this->prepareOptionsNested($options);
			}
			else
			{
				$options = JHelperTags::convertPathsToNames($options);
			}

			return $options;
		}
	}
} else {
	require_once JPATH_SITE . DS . 'libraries' . DS . 'joomla' . DS . 'form' . DS . 'fields' . DS . 'text.php';

	class JFormFieldObtemptag extends JFormFieldText {
		public $type = 'obtemptag';

		protected function getInput() {
			$html   = "";
			$script = '
				<script type="text/javascript">
					var tag_label = document.getElementById("content_default_tags-lbl");
					tag_label.hide();
				</script>
			';

			return $html . $script;
		}
	}
}
/*

jimport('joomla.html.parameter.element');

class JElementK2categories extends JElement
{

	var	$_name = 'K2categories';
		
	
	public static function fetchElement($name, $value, &$node, $control_name)
	{
		$db = JFactory::getDBO();
		$query = "SELECT u.id as value, u.name as text FROM #__k2_categories as u ORDER BY u.name";	
	
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		if ($rows) {
			$options[] = JHTML::_('select.option', '', JText::_('COM_OBGRABBER_ADAPTER_K2_SELECT_CATEGORY'));
			$options = array_merge($options, $rows);
			$authors = JHTML::_('select.genericlist', $options, ''.$control_name.'['.$name.'][]', 'multiple="multiple"', 'value', 'text', $value, $control_name.$name );
			return $authors;
		} else {
			return JText::_('COM_OBGRABBER_ADAPTER_K2_PARAMS_NO_DATA');
		}
	}
}

*/