<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');

// Create shortcuts to some parameters.
$params  = $this->item->params;
$tpl_params 	= JFactory::getApplication()->getTemplate(true)->params;
$images  = json_decode($this->item->images);
$urls    = json_decode($this->item->urls);
$canEdit = $params->get('access-edit');
$user    = JFactory::getUser();
$info    = $params->get('info_block_position', 0);
JHtml::_('behavior.caption');
$useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
	|| $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category') || $params->get('show_author'));

	$post_format = $params->get('post_format', 'standard');

	$has_post_format = $tpl_params->get('show_post_format');

	if($this->print) $has_post_format = false;

?>
<div class="detail_service">
	<div class="row">
		<div class="col-sm-3 col-xs-12">
			<?php
			$position = "with_page";
			$document = JFactory::getDocument();
			$renderer   = $document->loadRenderer('modules');
			$options   = array('style' => 'sp_xhtml');
			echo $renderer->render($position, $options, null);
			?>
			<div class="sp-module">
				<h3 class="sp-module-title">Download</h3>
				<div class="list_download">
					<div class="brochure_item">
						<?php
						$quote_pdf = json_decode($params->get('quote_files'));
						$link_pdf = $quote_pdf->quote_pdf;
						$link_brochue = $quote_pdf->quote_doc;
						?>
						<a href="<?php echo $link_pdf[0];?>" target="_blank">
							<i class="fa fa-file-pdf-o"></i>
							<span>Download Brochure</span>
						</a>
					</div>
					<div class="price_item">
						<a href="<?php echo $link_brochue[0];?>" target="_blank">
							<i class="fa fa-file-excel-o"></i>
							<span>Download Price 2016</span>
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="col-sm-9 col-xs-12">
			<article class="item service_item item-page<?php echo $this->pageclass_sfx . ($this->item->featured) ? ' item-featured' : ''; ?>" itemscope itemtype="http://schema.org/Article">
				<meta itemprop="inLanguage" content="<?php echo ($this->item->language === '*') ? JFactory::getConfig()->get('language') : $this->item->language; ?>" />

				<div class="galleries">
					<ul class="bxslider">
					<?php
					$galeries = json_decode($params->get('service_galleries'));
					$details_part = $galeries->sv_gl_img;
					foreach($details_part as $key=>$part) {
						?>
						<li><img src="<?php echo $part; ?>" alt="" /></li>
						<?php
					}
					?>
					</ul>
					<div id="bx-pager">
						<?php $i=0; foreach($details_part as $key=>$part) {?>
						<a data-slide-index="<?php echo $i;?>" href=""><img src="<?php echo $part; ?>" alt="" /></a>
						<?php $i++;}?>
					</div>
				</div>
				<div class="entry-header<?php echo $has_post_format ? ' has-post-format': ''; ?>">

					<?php if ($params->get('show_title') || $params->get('show_author')) : ?>
						<h2 itemprop="name">
							<?php if ($params->get('show_title')) : ?>
								<?php echo $this->escape($this->item->title); ?>
							<?php endif; ?>
						</h2>
						<?php if ($this->item->state == 0) : ?>
							<span class="label label-warning"><?php echo JText::_('JUNPUBLISHED'); ?></span>
						<?php endif; ?>
						<?php if (strtotime($this->item->publish_up) > strtotime(JFactory::getDate())) : ?>
							<span class="label label-warning"><?php echo JText::_('JNOTPUBLISHEDYET'); ?></span>
						<?php endif; ?>
						<?php if ((strtotime($this->item->publish_down) < strtotime(JFactory::getDate())) && $this->item->publish_down != '0000-00-00 00:00:00') : ?>
							<span class="label label-warning"><?php echo JText::_('JEXPIRED'); ?></span>
						<?php endif; ?>
					<?php endif; ?>

					<?php echo JLayoutHelper::render('joomla.content.post_formats.icons',  $post_format); ?>


				</div>



				<?php if (!$params->get('show_intro')) : echo $this->item->event->afterDisplayTitle; endif; ?>
				<?php echo $this->item->event->beforeDisplayContent; ?>

				<?php if (isset($urls) && ((!empty($urls->urls_position) && ($urls->urls_position == '0')) || ($params->get('urls_position') == '0' && empty($urls->urls_position)))
					|| (empty($urls->urls_position) && (!$params->get('urls_position')))) : ?>
					<?php echo $this->loadTemplate('links'); ?>
				<?php endif; ?>
				<?php if ($params->get('access-view')):?>

					<?php //echo JLayoutHelper::render('joomla.content.full_image', $this->item); ?>

					<?php
					if (!empty($this->item->pagination) && $this->item->pagination && !$this->item->paginationposition && !$this->item->paginationrelative):
						echo $this->item->pagination;
					endif;
					?>
					<?php if (isset ($this->item->toc)) :
						echo $this->item->toc;
					endif; ?>
					<div itemprop="articleBody">
						<?php echo $this->item->text; ?>
					</div>


					<?php // Optional teaser intro text for guests ?>
				<?php elseif ($params->get('show_noauth') == true && $user->get('guest')) : ?>
					<?php echo $this->item->introtext; ?>




				<?php endif; ?>

				<div class="entry-header list_prices">
					<h2>Price</h2>
					<div class="list_price">
						<div class="row">
							<?php
							$prices = json_decode($params->get('price_list'));
							//var_dump($prices);
							$details_price = $prices->item_content;
							$price_item = $prices->item_currency;
							//var_dump($price_item);
							foreach($details_price as $key=>$part) {
								?>
								<div class="col-sm-6 col-xs-12 item">
									<div class="clear">
										<?php echo $part; ?><span><?php echo $price_item[$key];?></span>
									</div>
								</div>
								<?php
							}
							?>
						</div>
					</div>
				</div>

				<?php echo $this->item->event->afterDisplayContent; ?>

			</article>
		</div>
	</div>
</div>

