<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');

// Create shortcuts to some parameters.
$params  = $this->item->params;
$tpl_params 	= JFactory::getApplication()->getTemplate(true)->params;
$images  = json_decode($this->item->images);
$urls    = json_decode($this->item->urls);
$canEdit = $params->get('access-edit');
$user    = JFactory::getUser();
$info    = $params->get('info_block_position', 0);
JHtml::_('behavior.caption');
$useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
	|| $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category') || $params->get('show_author'));

	$post_format = $params->get('post_format', 'standard');

	$has_post_format = $tpl_params->get('show_post_format');

	if($this->print) $has_post_format = false;

?>

<div class="detail_team">
	<div class="row">
		<div class="thumb col-md-3 col-sm-4 col-xs-12">
			<div class="inner">
				<?php
				//if($post_format=='standard') {
				echo JLayoutHelper::render('joomla.content.intro_image', $this->item);
				//} else {
				//	echo JLayoutHelper::render('joomla.content.post_formats.post_' . $post_format, array('params' => $post_attribs, 'item' => $item));
				//}
				?>
			</div>
		</div>
		<div class="content col-md-6 col-sm-8 col-xs-12">
			<h1 class="name"><?php echo $this->item->title; ?></h1>
			<div class="subtitle"><?php echo $params->get('team_position');?></div>
			<div class="description">
				<?php echo $this->item->text; ?>
			</div>
		</div>
		<div class="info col-md-3 col-sm-12 col-xs-12">
			<div class="email"><i class="fa fa-envelope"></i> <a href="mailto:<?php echo $params->get('team_email');?>"><?php echo $params->get('team_email');?></a></div>
			<div class="phone"><i class="fa fa-phone"></i> <a href=""><?php echo $params->get('team_phone');?></a></div>
			<?php
			$social = json_decode($params->get('team_social_info'));
			$icon = $social->team_social_icon;
			$link = $social->team_social_url;
			?>
			<div class="social_link">
				<?php foreach($icon as $key=>$part) { ?>
					<a href="<?php echo $link[$key];?>"><i class="<?php echo $part;?>"></i></a>
				<?php }?>
			</div>
		</div>
	</div>
</div>

<div class="relate_team">
	<?php
	$document = JFactory::getDocument();
	$renderer   = $document->loadRenderer('modules');
	$position   = 'related_team';
	$options   = array('style' => 'sp_xhtml');
	echo $renderer->render($position, $options, null);
	?>
</div>