<?php
/**
 *
 * Show the product details page
 *
 * @package	VirtueMart
 * @subpackage
 * @author Max Milbers, Eugen Stranz, Max Galt
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2014 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: default.php 8842 2015-05-04 20:34:47Z Milbo $
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

/* Let's see if we found the product */
if (empty($this->product)) {
	echo vmText::_('COM_VIRTUEMART_PRODUCT_NOT_FOUND');
	echo '<br /><br />  ' . $this->continue_link_html;
	return;
}

echo shopFunctionsF::renderVmSubLayout('askrecomjs',array('product'=>$this->product));



if(vRequest::getInt('print',false)){ ?>
<body onload="javascript:print();">
<?php } ?>

<div class="productdetails-view productdetails">


	<?php // Back To Category Button
	if ($this->product->virtuemart_category_id) {
		$catURL =  JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id='.$this->product->virtuemart_category_id, FALSE);
		$categoryName = vmText::_($this->product->category_name) ;
	} else {
		$catURL =  JRoute::_('index.php?option=com_virtuemart');
		$categoryName = vmText::_('COM_VIRTUEMART_SHOP_HOME') ;
	}
	?>

	<div class="row">
		<div class="images col-sm-6">
			<?php
			echo $this->loadTemplate('images');
			$count_images = count ($this->product->images);
			if ($count_images > 1) {
				echo $this->loadTemplate('addition_img');
			}
			?>
		</div>
		<div class="summary entry-summary col-sm-6">
			<?php // Product Title   ?>
			<h1 itemprop="name" class="product_title entry-title"><?php echo $this->product->product_name ?></h1>
			<?php // Product Title END   ?>
			<?php // afterDisplayTitle Event
			echo $this->product->event->afterDisplayTitle ?>

			<?php
			// Product Edit Link
			echo $this->edit_link;
			// Product Edit Link END
			echo '<div class="star-rating">';
			echo shopFunctionsF::renderVmSubLayout('rating',array('showRating'=>$this->showRating,'product'=>$this->product));
			echo '</div>';
			//echo shopFunctionsF::renderVmSubLayout('customfields',array('product'=>$this->product,'position'=>'ontop'));
			//echo shopFunctionsF::renderVmSubLayout('customfields',array('product'=>$this->product,'position'=>'normal'));
			//echo shopFunctionsF::renderVmSubLayout('customfields',array('product'=>$this->product,'position'=>'onbot'));
			if (is_array($this->productDisplayShipments)) {
				foreach ($this->productDisplayShipments as $productDisplayShipment) {
					echo $productDisplayShipment . '';
				}
			}
			if (is_array($this->productDisplayPayments)) {
				foreach ($this->productDisplayPayments as $productDisplayPayment) {
					echo $productDisplayPayment . '';
				}
			}

			//In case you are not happy using everywhere the same price display fromat, just create your own layout
			//in override /html/fields and use as first parameter the name of your file
			echo shopFunctionsF::renderVmSubLayout('ob_price',array('product'=>$this->product,'currency'=>$this->currency,'element'=>'p'));
			echo '<div class="clear"></div>';
			// Product Short Description
			if (!empty($this->product->product_s_desc)) {
				?>
				<div class="product-short-description">
					<?php
					/** @todo Test if content plugins modify the product description */
					echo nl2br($this->product->product_s_desc);
					?>
				</div>
				<?php
			} // Product Short Description END
			echo shopFunctionsF::renderVmSubLayout('addtocart',array('product'=>$this->product,'row'=>0,'show_qty'=>true));

			echo shopFunctionsF::renderVmSubLayout('stockhandle',array('product'=>$this->product));
			?>
			<div class="product_meta">
				<span class="sku"><?php echo JText::_('SKU');?>: <?php echo $this->product->product_sku;?></span>
				<span class="posted_in"><?php echo JText::_('VIRTUEMART_SHOP_CATEGORIES'); ?>
					<?php
					$link_cats = array();
					foreach( $this->product->categoryItem as $categoryitem ) {
						$catURL =  JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $categoryitem['virtuemart_category_id'], FALSE);
						$link_cats[] = '<a href="' . $catURL . '" rel="tag">' . $categoryitem['category_name'] . '</a>';
					}
					echo implode(', ', $link_cats);
					?>
				</span>
			</div>
			<?php
			$ItemidStr = '';
			$Itemid = shopFunctionsF::getLastVisitedItemId();
			if(!empty($Itemid)){
				$ItemidStr = '&Itemid='.$Itemid;
			}
			$image_url = JUri::root() . $this->product->images[0]->file_url;
			$share_img = urlencode($image_url);
			$share_url = urlencode($this->product->link.$ItemidStr);
			?>
			<div class="ob-share-product">
				<ul class="share_show">
					<li>
						<a target="_blank" class="facebook" href="https://www.facebook.com/sharer.php?s=100&p[title]=<?php echo $product->product_name; ?>&p[url]=<?php echo $share_url;?>&p[images][0]=<?php echo $share_img; ?>" title="Facebook">
							<i class="fa fa-facebook"></i>
						</a>
					</li>
					<li>
						<a target="_blank" class="twitter" href="https://twitter.com/share?url=<?php echo $share_url;?>&text=<?php echo $product->product_name; ?>" title="Twitter">
							<i class="fa fa-twitter"></i>
						</a>
					</li>
					<li>
						<a target="_blank" class="pinterest" href="http://pinterest.com/pin/create/button/?url=<?php echo $share_url;?>&description=<?php echo $product->product_s_desc; ?>&media=<?php echo $share_img; ?>" onclick="window.open(this.href); return false;" title="Pinterest">
							<i class="fa fa-pinterest"></i>
						</a>
					</li>
					<li>
						<a target="_blank" class="googleplus" href="https://plus.google.com/share?url=<?php echo $share_url;?>&title=<?php echo $product->product_name; ?>" title="Google Plus" onclick="javascript:window.open(this.href, &quot;&quot;, &quot;menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600&quot;);return false;">
							<i class="fa fa-google"></i>
						</a>
					</li>
				</ul>
			</div>
		</div>
	</div>
	<?php
	// event onContentBeforeDisplay
	echo $this->product->event->beforeDisplayContent;
	?>
	<div class="virtuemart-tabs vm-tabs-wrapper">
		<ul class="tabs vm-tabs">
			<li class="description_tab active">
				<a href="#tab-description"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DESC_TITLE') ?></a>
			</li>
			<li class="reviews_tab">
				<a href="#tab-reviews"><?php echo vmText::_ ('COM_VIRTUEMART_REVIEWS') ?></a>
			</li>
		</ul>
		<div class="panel entry-content wc-tab active" id="tab-description">
			<?php
			// Product Description
			if (!empty($this->product->product_desc)) {
				echo $this->product->product_desc;
			} // Product Description END
			?>
		</div>
		<div class="panel entry-content wc-tab" id="tab-reviews">
			<?php echo $this->loadTemplate('reviews'); ?>
		</div>
	</div>

	<?php

	echo shopFunctionsF::renderVmSubLayout('ob_related',array('product'=>$this->product,'position'=>'related_products','class'=> 'product-related-products','customTitle' => true,'showRating'=>$this->showRating ));

	?>

	<?php // onContentAfterDisplay event
	echo $this->product->event->afterDisplayContent;

	$j = 'jQuery(document).ready(function($) {
	Virtuemart.product(jQuery("form.product"));

	$("form.js-recalculate").each(function(){
		if ($(this).find(".product-fields").length && !$(this).find(".no-vm-bind").length) {
			var id= $(this).find(\'input[name="virtuemart_product_id[]"]\').val();
			Virtuemart.setproducttype($(this),id);

		}
	});
});';
	//vmJsApi::addJScript('recalcReady',$j);

	/** GALT
	 * Notice for Template Developers!
	 * Templates must set a Virtuemart.container variable as it takes part in
	 * dynamic content update.
	 * This variable points to a topmost element that holds other content.
	 */
	$j = "Virtuemart.container = jQuery('.productdetails-view');
Virtuemart.containerSelector = '.productdetails-view';";

	vmJsApi::addJScript('ajaxContent',$j);

	echo vmJsApi::writeJS();
	?> </div>



