<?php
/**
 * sublayout products
 *
 * @package	VirtueMart
 * @author Max Milbers
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2014 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL2, see LICENSE.php
 * @version $Id: cart.php 7682 2014-02-26 17:07:20Z Milbo $
 */

defined('_JEXEC') or die('Restricted access');

$product = $viewData['product'];
$showRating = $viewData['showRating'];
$position = $viewData['position'];
$customTitle = isset($viewData['customTitle'])? $viewData['customTitle']: false;;
if(isset($viewData['class'])){
    $class = $viewData['class'];
} else {
    $class = 'product-fields';
}

if (!empty($product->customfieldsSorted[$position])) {
    ?>
    <div class="<?php echo $class?>">
        <?php
        if($customTitle and isset($product->customfieldsSorted[$position][0])){
            $field = $product->customfieldsSorted[$position][0]; ?>
            <h3><?php echo vmText::_ ($field->custom_title) ?></h3>
            <?php
        }
        $custom_title = null;
        ?>
        <div class="grid_products">
            <div class="row">
                <?php
                foreach ($product->customfieldsSorted[$position] as $field) {
                    if ( $field->is_hidden || empty($field->display)) continue; //OSP http://forum.virtuemart.net/index.php?topic=99320.0
                    $productModel = VmModel::getModel('Product');
                    $product =  $productModel->getProduct($field->customfield_value);
                    $productModel->addImages($product);
                    ?>
                    <div class="col-md-4 col-sm-6 item">
                        <?php echo shopFunctionsF::renderVmSubLayout('itemGrid',array('product'=>$product,'showRating'=>$showRating)); ?>
                    </div>
                    <?php
                    $custom_title = $field->custom_title;
                } ?>
            </div>
        </div>
        <div class="clear"></div>
    </div>
    <?php
} ?>