<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_latest
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die;
$count = count( $list );
?>
<div class="latestnews <?php echo $moduleclass_sfx; ?> recent_article">
	<div class="row">
		<?php
		foreach ($list as $item) {
			?>
			<div class="col-md-3 col-sm-6 col-xs-12">
				<div class="from_blog item tCenter">
					<?php
					$post_attribs = new JRegistry(json_decode( $item->attribs ));
					$post_format = $item->params->get( 'post_format', '' );
					$author = ( $item->created_by_alias ? $item->created_by_alias : $item->author );
					?>
					<div itemscope itemtype="http://schema.org/Article">
						<div class="thumb">
							<div class="date">
								<span class="day"><?php echo JHtml::_( 'date', $item->created, 'd' ); ?></span>
								<span class="month"><?php echo JHtml::_( 'date', $item->created, 'M' ); ?></span>
							</div>
							<?php
							echo JLayoutHelper::render('joomla.content.intro_image', $item);
							?>
						</div>
						<div class="article-title-wrapper">
							<h4><a class="article-title" href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a></h4>
							<div class="article-info">
								<?php echo JText::_( 'by' ); ?> <strong><?php echo $author;?></strong>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
		?>
	</div>
</div>
