<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_latest
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die;
$count = count( $list );
?>
<div class="latestnews <?php echo $moduleclass_sfx; ?> slider_recent">
	<div class="lists">
		<?php
		foreach ($list as $item) {
			?>
			<div class="from_blog item">
				<?php
				$post_attribs = new JRegistry(json_decode( $item->attribs ));
				$post_format = $item->params->get( 'post_format', '' );
				$author = ( $item->created_by_alias ? $item->created_by_alias : $item->author );
				?>
				<div itemscope itemtype="http://schema.org/Article">
					<?php
					if($post_format=='standard') {
						echo JLayoutHelper::render('joomla.content.intro_image', $item);
					} else {
						echo JLayoutHelper::render('joomla.content.post_formats.post_' . $post_format, array('params' => $post_attribs, 'item' => $item));
					}
					?>
					<div class="article-title-wrapper">
						<h4><a class="article-title" href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a></h4>
						<div class="article-intro">
							<?php echo $item->introtext; ?>
						</div>
						<div class="article-info clear">
							<span class="author"><?php echo $author;?></span><span class="date"><?php echo JHtml::_( 'date', $item->created, 'd M Y' ); ?></span>
							<a href="<?php echo $item->link; ?>" class="readmore"><?php echo JText::_('READMORE');?></a>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
		?>
	</div>
</div>
