/**
* @package Helix3 Framework
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2015 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
jQuery(function($) {

    var $body = $('body'),
    $wrapper = $('.body-innerwrapper'),
    $toggler = $('#offcanvas-toggler'),
    $close = $('.close-offcanvas'),
    $offCanvas = $('.offcanvas-menu');

    $toggler.on('click', function(event){
        event.preventDefault();
        stopBubble (event);
        setTimeout(offCanvasShow, 50);
    });

    $close.on('click', function(event){
        event.preventDefault();
        offCanvasClose();
    });

    var offCanvasShow = function(){
        $body.addClass('offcanvas');
        $wrapper.on('click',offCanvasClose);
        $close.on('click',offCanvasClose);
        $offCanvas.on('click',stopBubble);

    };

    var offCanvasClose = function(){
        $body.removeClass('offcanvas');
        $wrapper.off('click',offCanvasClose);
        $close.off('click',offCanvasClose);
        $offCanvas.off('click',stopBubble);
    };

    var stopBubble = function (e) {
        e.stopPropagation();
        return true;
    };

    //Mega Menu
    $('.sp-megamenu-wrapper').parent().parent().css('position','static').parent().css('position', 'relative');
    $('.sp-menu-full').each(function(){
        $(this).parent().addClass('menu-justify');
    });

    //Sticky Menu
    $(document).ready(function(){
        $("body.sticky-header").find('#sp-header').sticky({topSpacing:0})
    });

    //Tooltip
    $('[data-toggle="tooltip"]').tooltip();
    
    $(document).on('click', '.sp-rating .star', function(event) {
        event.preventDefault();

        var data = {
            'action':'voting',
            'user_rating' : $(this).data('number'),
            'id' : $(this).closest('.post_rating').attr('id')
        };

        var request = {
                'option' : 'com_ajax',
                'plugin' : 'helix3',
                'data'   : data,
                'format' : 'json'
            };

        $.ajax({
            type   : 'POST',
            data   : request,
            beforeSend: function(){
                $('.post_rating .ajax-loader').show();
            },
            success: function (response) {
                var data = $.parseJSON(response.data);

                $('.post_rating .ajax-loader').hide();

                if (data.status == 'invalid') {
                    $('.post_rating .voting-result').text('You have already rated this entry!').fadeIn('fast');
                }else if(data.status == 'false'){
                    $('.post_rating .voting-result').text('Somethings wrong here, try again!').fadeIn('fast');
                }else if(data.status == 'true'){
                    var rate = data.action;
                    $('.voting-symbol').find('.star').each(function(i) {
                        if (i < rate) {
                           $( ".star" ).eq( -(i+1) ).addClass('active');
                        }
                    });

                    $('.post_rating .voting-result').text('Thank You!').fadeIn('fast');
                }

            },
            error: function(){
                $('.post_rating .ajax-loader').hide();
                $('.post_rating .voting-result').text('Failed to rate, try again!').fadeIn('fast');
            }
        });
    });

    //counter
    $('.counters-box .display-percentage').counterUp({
        delay: 100,
        time: 1000
    });

    $('.bxslider').bxSlider({
        pagerCustom: '#bx-pager'
    });

    //slider testimonial
    $('.ob_tesimonials .slider').bxSlider({
        minSlides: 1,
        maxSlides: 3,
        slideWidth: 360,
        slideMargin: 30,
    });

    //tab
    $('.tabs .tab a').click(function(){
        var key = $(this).parent().attr('rel');
        $('.tabs .tab.active').removeClass('active');
        $(this).parent().addClass('active');
        $('.lists_event .item.active').removeClass('active');
        $('.lists_event .item.'+key).addClass('active');
        return false;
    });

    //tab_product detail
    $('.virtuemart-tabs .tabs li a').click(function(){
        $('.virtuemart-tabs .panel.active').removeClass('active');
        $('.virtuemart-tabs .tabs li.active').removeClass('active');
        $(this).parent().addClass('active');
        $($(this).attr('href')).addClass('active');
        return false;
    });

    //Back To top
    var back_to_top = function () {
        jQuery(window).scroll(function () {
            if (jQuery(this).scrollTop() > 100) {
                jQuery('#back-to-top').fadeIn();
            } else {
                jQuery('#back-to-top').fadeOut();
            }
        });
        jQuery('#back-to-top').click(function () {
            jQuery('html, body').animate({scrollTop: '0px'}, 800);
            return false;
        });
    }
    back_to_top();

    $('select.autoSubmit').on('change', function() {
        this.form.submit();
    });

    $('#searchModal').on('shown.bs.modal', function () {
        $('#searchModal input[name="keyword"]').focus();
    });

    // Skills - Percent Bar
    function pattiskills() {
        jQuery('.skillbar').each(function(){
            var barwidth = jQuery(this).attr('data-percent');
            jQuery(this).waypoint(function() {
                    jQuery(this).find('.skillbar-bar').animate({
                        width: barwidth
                    },2000);
                    jQuery(this).find('.skill-bar-percent').animate({
                        'left':barwidth,
                        'margin-left': '-19px',
                        'opacity': 1
                    }, 2000);
                },
                {
                    offset: '90%',
                    triggerOnce: true
                });
        });
    }
    jQuery(document).ready(function() {
        pattiskills();
    });

    $('.ob_lightbox_shop .addtocart-area .addtocart-button input[type="submit"]').click(function(){
        $('.modal.in, .modal-backdrop.in').removeClass('in');
        $('body.modal-open').removeClass('modal-open').css('padding-right','0');
    });

    // Loading
    var loading = function(){
        $('.ob_loading').fadeOut(1000, function(){
            $('body').removeClass('loading');
        });
    }
    $(window).load(function() {
        loading();
    });

});