<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

AddonParser::addAddon('sp_ob_prices','sp_ob_prices_addon');
AddonParser::addAddon('sp_ob_prices_item','sp_ob_prices_item_addon');

function sp_ob_prices_addon($atts, $content){

	$class = $column = '';
	extract(spAddonAtts(array(
		"column"=>'',
		"class"=>'',
	), $atts));
	ob_start();
	?>
	<div class="ob_prices <?php echo $class;?>">
		<?php
		//echo AddonParser::spDoAddon($content);
		$columns = 12 / $column;
		preg_match_all('/\[[^\]]*\]/i', $content, $matches);
		if (isset($matches[0]) && count($matches[0] > 0)) {
			foreach ($matches[0] as $item) {
				echo '<div class="col-md-' . $columns . ' col-sm-6 col-xs-12">';
				echo AddonParser::spDoAddon($item);
				echo '</div>';
			}
		} else {
			echo AddonParser::spDoAddon($content);
		}
		?>
	</div>
	<?php
	$html = ob_get_clean();
	return $html;
}

function sp_ob_prices_item_addon( $atts ){

	$title = $content = $price = $sub_title = $text_btn = $link_btn = "";
	extract(spAddonAtts(array(
		"title"=>'',
		"content"=>'',
		"sub_title"=>'',
		"text_btn"=>'',
		"link_btn"=>'',
		"price"=>'',
	), $atts));
	ob_start();
	?>
	<div class="item_price">
		<div class="head">
			<h3><?php echo $title;?></h3>
		</div>
		<div class="price"><?php echo $price;?></div>
		<div class="sub"><?php echo $sub_title;?></div>
		<div class="content"><?php echo $content;?></div>
		<a href="<?php echo $link_btn;?>" class="sppb-btn sppb-btn-primary"><?php echo $text_btn;?></a>
	</div>
	<?php
	$html = ob_get_clean();
	return $html;
}